/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractBackupJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractIncrementalBackupJob
extends AbstractBackupJob
implements ItemsPersistenceListener {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.IncrementalBackupJob");
    protected final List<ItemStateChangesLog> suspendBuffer = new ArrayList<ItemStateChangesLog>();

    public AbstractIncrementalBackupJob() {
        this.id = 1;
        this.notifyListeners();
    }

    public final int getType() {
        return 2;
    }

    public void onSaveItems(ItemStateChangesLog chlog) {
        if (this.state == 4) {
            return;
        }
        if (this.state == 1) {
            this.suspendBuffer.add(chlog);
        } else if (this.state == 2) {
            try {
                this.save(chlog);
            }
            catch (IOException e) {
                log.error("Incremental backup: Can't save log ", e);
                this.notifyError("Incremental backup: Can't save log ", e);
            }
        }
    }

    public final void run() {
        this.repository.addItemPersistenceListener(this.workspaceName, (ItemsPersistenceListener)this);
        this.state = 2;
        this.notifyListeners();
    }

    public final void suspend() {
        this.state = 1;
        ++this.id;
        this.notifyListeners();
    }

    public final URL resume() {
        try {
            this.url = this.createStorage();
            for (ItemStateChangesLog log : this.suspendBuffer) {
                this.save(log);
            }
            this.suspendBuffer.clear();
            this.state = 2;
            if (this.config.getIncrementalJobNumber() != 0 && this.id == this.config.getIncrementalJobNumber() + 1) {
                this.state = 4;
            }
            this.notifyListeners();
        }
        catch (FileNotFoundException e) {
            log.error("Incremental backup: resume failed ", e);
            this.notifyError("Incremental backup: resume failed ", e);
        }
        catch (IOException e) {
            log.error("Incremental backup: resume failed +", e);
            this.notifyError("Incremental backup: resume failed ", e);
        }
        return this.url;
    }

    protected abstract void save(ItemStateChangesLog var1) throws IOException;
}

