/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.sshd.common.util.DirectoryScanner;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCommand
implements Command,
Runnable {
    protected static final Logger log = LoggerFactory.getLogger(ScpCommand.class);
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int ERROR = 2;
    protected String name;
    protected boolean optR;
    protected boolean optT;
    protected boolean optF;
    protected boolean optV;
    protected boolean optD;
    protected boolean optP;
    protected String root;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback callback;
    protected IOException error;

    public ScpCommand(String[] args) {
        this.name = Arrays.asList(args).toString();
        if (log.isDebugEnabled()) {
            log.debug("Executing command {}", (Object)this.name);
        }
        this.root = ".";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block9: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.optF = true;
                            continue block9;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block9;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block9;
                        }
                        case 't': {
                            this.optT = true;
                            continue block9;
                        }
                        case 'v': {
                            this.optV = true;
                            continue block9;
                        }
                        case 'd': {
                            this.optD = true;
                        }
                    }
                }
                continue;
            }
            if (i != args.length - 1) continue;
            this.root = args[args.length - 1];
        }
        if (!this.optF && !this.optT) {
            this.error = new IOException("Either -f or -t option should be set");
        }
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(Environment env) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        new Thread((Runnable)this, "ScpCommand: " + this.name).start();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block29: {
            int exitValue = 0;
            String exitMessage = null;
            try {
                if (this.optT) {
                    this.ack();
                    block13: while (true) {
                        String line;
                        boolean isDir = false;
                        int c = this.readAck(true);
                        switch (c) {
                            case -1: {
                                return;
                            }
                            case 68: {
                                isDir = true;
                            }
                            case 67: 
                            case 69: {
                                line = (char)c + this.readLine();
                                break;
                            }
                            default: {
                                continue block13;
                            }
                        }
                        if (this.optR && isDir) {
                            this.writeDir(line, new File(this.root));
                            continue;
                        }
                        this.writeFile(line, new File(this.root));
                    }
                }
                if (this.optF) {
                    File file;
                    String pattern = this.root;
                    int idx = pattern.indexOf(42);
                    if (idx >= 0) {
                        String[] included;
                        String basedir = "";
                        int lastSep = pattern.substring(0, idx).lastIndexOf(47);
                        if (lastSep >= 0) {
                            basedir = pattern.substring(0, lastSep);
                            pattern = pattern.substring(lastSep + 1);
                        }
                        for (String path : included = new DirectoryScanner(basedir, pattern).scan()) {
                            File file2 = new File(basedir, path);
                            if (file2.isFile()) {
                                this.readFile(file2);
                                continue;
                            }
                            if (file2.isDirectory()) {
                                if (!this.optR) {
                                    this.out.write(1);
                                    this.out.write((path + " not a regular file\n").getBytes());
                                    continue;
                                }
                                this.readDir(file2);
                                continue;
                            }
                            this.out.write(1);
                            this.out.write((path + " unknown file type\n").getBytes());
                        }
                        break block29;
                    }
                    String basedir = "";
                    int lastSep = pattern.lastIndexOf(47);
                    if (lastSep >= 0) {
                        basedir = pattern.substring(0, lastSep);
                        pattern = pattern.substring(lastSep + 1);
                    }
                    if (!(file = new File(basedir, pattern)).exists()) {
                        throw new IOException(file + ": no such file or directory");
                    }
                    if (file.isFile()) {
                        this.readFile(file);
                        break block29;
                    }
                    if (file.isDirectory()) {
                        if (!this.optR) {
                            throw new IOException(file + " not a regular file");
                        }
                        this.readDir(file);
                        break block29;
                    }
                    throw new IOException(file + ": unknown file type");
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                try {
                    exitValue = 2;
                    exitMessage = e.getMessage();
                    this.out.write(exitValue);
                    this.out.write(exitMessage.getBytes());
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                log.info("Error in scp command", (Throwable)e);
            }
            finally {
                if (this.callback != null) {
                    this.callback.onExit(exitValue, exitMessage);
                }
            }
        }
    }

    protected void writeDir(String header, File path) throws IOException {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("Writing dir {}", (Object)path);
        }
        if (!header.startsWith("D")) {
            throw new IOException("Expected a D message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (length != 0) {
            throw new IOException("Expected 0 length for directory but got " + length);
        }
        if (path.exists() && path.isDirectory()) {
            file = new File(path, name);
        } else if (!path.exists() && path.getParentFile().exists() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (!(file.exists() && file.isDirectory() || file.mkdir())) {
            throw new IOException("Could not create directory " + file);
        }
        this.ack();
        while (true) {
            if ((header = this.readLine()).startsWith("C")) {
                this.writeFile(header, file);
                continue;
            }
            if (!header.startsWith("D")) break;
            this.writeDir(header, file);
        }
        if (!header.equals("E")) {
            throw new IOException("Unexpected message: '" + header + "'");
        }
        this.ack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String header, File path) throws IOException {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("Writing file {}", (Object)path);
        }
        if (!header.startsWith("C")) {
            throw new IOException("Expected a C message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        long length = Long.parseLong(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (path.exists() && path.isDirectory()) {
            file = new File(path, name);
        } else if (path.exists() && path.isFile()) {
            file = path;
        } else if (!path.exists() && path.getParentFile().exists() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (file.exists() && file.isDirectory()) {
            throw new IOException("File is a directory: " + file);
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Can not write to file: " + file);
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.ack();
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int len = (int)Math.min(length, (long)buffer.length);
                if ((len = this.in.read(buffer, 0, len)) <= 0) {
                    throw new IOException("End of stream reached");
                }
                ((OutputStream)os).write(buffer, 0, len);
                length -= (long)len;
            }
        }
        finally {
            ((OutputStream)os).close();
        }
        this.ack();
        this.readAck(false);
    }

    protected String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFile(File path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Reading file {}", (Object)path);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("C");
        buf.append("0644");
        buf.append(" ");
        buf.append(path.length());
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        FileInputStream is = new FileInputStream(path);
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
                this.out.write(buffer, 0, len);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        this.ack();
        this.readAck(false);
    }

    protected void readDir(File path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Reading directory {}", (Object)path);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("D");
        buf.append("0755");
        buf.append(" ");
        buf.append("0");
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck(false);
        for (File child : path.listFiles()) {
            if (child.isFile()) {
                this.readFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.readDir(child);
        }
        this.out.write("E\n".getBytes());
        this.out.flush();
        this.readAck(false);
    }

    protected void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    protected int readAck(boolean canEof) throws IOException {
        int c = this.in.read();
        switch (c) {
            case -1: {
                if (canEof) break;
                throw new EOFException();
            }
            case 0: {
                break;
            }
            case 1: {
                log.warn("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
        return c;
    }
}

