/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.sftp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpSubsystem
implements Command,
Runnable,
SessionAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 3;
    public static final String ALL_SFTP_IMPL = "3";
    public static final int SSH_FXP_INIT = 1;
    public static final int SSH_FXP_VERSION = 2;
    public static final int SSH_FXP_OPEN = 3;
    public static final int SSH_FXP_CLOSE = 4;
    public static final int SSH_FXP_READ = 5;
    public static final int SSH_FXP_WRITE = 6;
    public static final int SSH_FXP_LSTAT = 7;
    public static final int SSH_FXP_FSTAT = 8;
    public static final int SSH_FXP_SETSTAT = 9;
    public static final int SSH_FXP_FSETSTAT = 10;
    public static final int SSH_FXP_OPENDIR = 11;
    public static final int SSH_FXP_READDIR = 12;
    public static final int SSH_FXP_REMOVE = 13;
    public static final int SSH_FXP_MKDIR = 14;
    public static final int SSH_FXP_RMDIR = 15;
    public static final int SSH_FXP_REALPATH = 16;
    public static final int SSH_FXP_STAT = 17;
    public static final int SSH_FXP_RENAME = 18;
    public static final int SSH_FXP_READLINK = 19;
    public static final int SSH_FXP_LINK = 21;
    public static final int SSH_FXP_BLOCK = 22;
    public static final int SSH_FXP_UNBLOCK = 23;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FX_INVALID_HANDLE = 9;
    public static final int SSH_FX_NO_SUCH_PATH = 10;
    public static final int SSH_FX_FILE_ALREADY_EXISTS = 11;
    public static final int SSH_FX_WRITE_PROTECT = 12;
    public static final int SSH_FX_NO_MEDIA = 13;
    public static final int SSH_FX_NO_SPACE_ON_FILESYSTEM = 14;
    public static final int SSH_FX_QUOTA_EXCEEDED = 15;
    public static final int SSH_FX_UNKNOWN_PRINCIPAL = 16;
    public static final int SSH_FX_LOCK_CONFLICT = 17;
    public static final int SSH_FX_DIR_NOT_EMPTY = 18;
    public static final int SSH_FX_NOT_A_DIRECTORY = 19;
    public static final int SSH_FX_INVALID_FILENAME = 20;
    public static final int SSH_FX_LINK_LOOP = 21;
    public static final int SSH_FX_CANNOT_DELETE = 22;
    public static final int SSH_FX_INVALID_PARAMETER = 23;
    public static final int SSH_FX_FILE_IS_A_DIRECTORY = 24;
    public static final int SSH_FX_BYTE_RANGE_LOCK_CONFLICT = 25;
    public static final int SSH_FX_BYTE_RANGE_LOCK_REFUSED = 26;
    public static final int SSH_FX_DELETE_PENDING = 27;
    public static final int SSH_FX_FILE_CORRUPT = 28;
    public static final int SSH_FX_OWNER_INVALID = 29;
    public static final int SSH_FX_GROUP_INVALID = 30;
    public static final int SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK = 31;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_ACCESSTIME = 8;
    public static final int SSH_FILEXFER_ATTR_CREATETIME = 16;
    public static final int SSH_FILEXFER_ATTR_MODIFYTIME = 32;
    public static final int SSH_FILEXFER_ATTR_ACL = 64;
    public static final int SSH_FILEXFER_ATTR_OWNERGROUP = 128;
    public static final int SSH_FILEXFER_ATTR_SUBSECOND_TIMES = 256;
    public static final int SSH_FILEXFER_ATTR_BITS = 512;
    public static final int SSH_FILEXFER_ATTR_ALLOCATION_SIZE = 1024;
    public static final int SSH_FILEXFER_ATTR_TEXT_HINT = 2048;
    public static final int SSH_FILEXFER_ATTR_MIME_TYPE = 4096;
    public static final int SSH_FILEXFER_ATTR_LINK_COUNT = 8192;
    public static final int SSH_FILEXFER_ATTR_UNTRANSLATED_NAME = 16384;
    public static final int SSH_FILEXFER_ATTR_CTIME = 32768;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    public static final int SSH_FILEXFER_TYPE_SOCKET = 6;
    public static final int SSH_FILEXFER_TYPE_CHAR_DEVICE = 7;
    public static final int SSH_FILEXFER_TYPE_BLOCK_DEVICE = 8;
    public static final int SSH_FILEXFER_TYPE_FIFO = 9;
    public static final int SSH_FXF_ACCESS_DISPOSITION = 7;
    public static final int SSH_FXF_CREATE_NEW = 0;
    public static final int SSH_FXF_CREATE_TRUNCATE = 1;
    public static final int SSH_FXF_OPEN_EXISTING = 2;
    public static final int SSH_FXF_OPEN_OR_CREATE = 3;
    public static final int SSH_FXF_TRUNCATE_EXISTING = 4;
    public static final int SSH_FXF_APPEND_DATA = 8;
    public static final int SSH_FXF_APPEND_DATA_ATOMIC = 16;
    public static final int SSH_FXF_TEXT_MODE = 32;
    public static final int SSH_FXF_BLOCK_READ = 64;
    public static final int SSH_FXF_BLOCK_WRITE = 128;
    public static final int SSH_FXF_BLOCK_DELETE = 256;
    public static final int SSH_FXF_BLOCK_ADVISORY = 512;
    public static final int SSH_FXF_NOFOLLOW = 1024;
    public static final int SSH_FXF_DELETE_ON_CLOSE = 2048;
    public static final int SSH_FXF_ACCESS_AUDIT_ALARM_INFO = 4096;
    public static final int SSH_FXF_ACCESS_BACKUP = 8192;
    public static final int SSH_FXF_BACKUP_STREAM = 16384;
    public static final int SSH_FXF_OVERRIDE_OWNER = 32768;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    public static final int SSH_FXF_TEXT = 64;
    public static final int ACE4_READ_DATA = 1;
    public static final int ACE4_LIST_DIRECTORY = 1;
    public static final int ACE4_WRITE_DATA = 2;
    public static final int ACE4_ADD_FILE = 2;
    public static final int ACE4_APPEND_DATA = 4;
    public static final int ACE4_ADD_SUBDIRECTORY = 4;
    public static final int ACE4_READ_NAMED_ATTRS = 8;
    public static final int ACE4_WRITE_NAMED_ATTRS = 16;
    public static final int ACE4_EXECUTE = 32;
    public static final int ACE4_DELETE_CHILD = 64;
    public static final int ACE4_READ_ATTRIBUTES = 128;
    public static final int ACE4_WRITE_ATTRIBUTES = 256;
    public static final int ACE4_DELETE = 65536;
    public static final int ACE4_READ_ACL = 131072;
    public static final int ACE4_WRITE_ACL = 262144;
    public static final int ACE4_WRITE_OWNER = 524288;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    private ExitCallback callback;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private Environment env;
    private ServerSession session;
    private boolean closed = false;
    private File root;
    private int version;
    private Map<String, Handle> handles = new HashMap<String, Handle>();
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public SftpSubsystem(File root) {
        this.root = root.getAbsoluteFile();
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void start(Environment env) throws IOException {
        this.env = env;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(this.in);
                while (true) {
                    int l;
                    int length;
                    if ((length = dis.readInt()) < 5) {
                        throw new IllegalArgumentException();
                    }
                    Buffer buffer = new Buffer(length + 4);
                    buffer.putInt(length);
                    for (int nb = length; nb > 0; nb -= l) {
                        l = dis.read(buffer.array(), buffer.wpos(), nb);
                        if (l < 0) {
                            throw new IllegalArgumentException();
                        }
                        buffer.wpos(buffer.wpos() + l);
                    }
                    this.process(buffer);
                }
            }
            catch (Throwable t) {
                if (!this.closed) {
                    this.log.error("Exception caught in SFTP subsystem", t);
                }
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ioe) {
                        this.log.error("Could not close DataInputStream", (Throwable)ioe);
                    }
                }
                dis = null;
                this.callback.onExit(0);
            }
        }
        catch (Throwable throwable) {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ioe) {
                    this.log.error("Could not close DataInputStream", (Throwable)ioe);
                }
            }
            dis = null;
            this.callback.onExit(0);
            throw throwable;
        }
    }

    protected void process(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        switch (type) {
            case 1: {
                if (length != 5) {
                    throw new IllegalArgumentException();
                }
                this.version = id;
                if (this.version >= 3 && this.version <= 3) {
                    buffer.clear();
                    buffer.putByte((byte)2);
                    buffer.putInt(this.version);
                    this.send(buffer);
                    break;
                }
                this.sendStatus(id, 8, "SFTP server only support versions 3");
                break;
            }
            case 3: {
                if (this.version <= 4) {
                    String path = buffer.getString();
                    int pflags = buffer.getInt();
                    try {
                        File file = this.resolveFile(path);
                        if (file.exists()) {
                            if ((pflags & 8) != 0 && (pflags & 0x20) != 0) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                        } else if ((pflags & 8) != 0 && !file.createNewFile()) {
                            this.sendStatus(id, 4, "Can not create " + path);
                        }
                        String acc = ((pflags & 3) != 0 ? "r" : "") + ((pflags & 2) != 0 ? "w" : "");
                        RandomAccessFile raf = new RandomAccessFile(file, acc);
                        if ((pflags & 0x10) != 0) {
                            raf.setLength(0L);
                        }
                        String handle = UUID.randomUUID().toString();
                        this.handles.put(handle, new FileHandle(file, raf, pflags));
                        this.sendHandle(id, handle);
                    }
                    catch (IOException e) {
                        this.sendStatus(id, 4, e.getMessage());
                    }
                    break;
                }
                String path = buffer.getString();
                int acc = buffer.getInt();
                int flags = buffer.getInt();
                try {
                    RandomAccessFile raf;
                    File file = this.resolveFile(path);
                    switch (flags & 7) {
                        case 0: {
                            if (file.exists()) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                            if (!file.createNewFile()) {
                                this.sendStatus(id, 4, "Can not create " + path);
                            }
                            raf = new RandomAccessFile(file, "rw");
                            break;
                        }
                        case 1: {
                            if (file.exists()) {
                                this.sendStatus(id, 11, path);
                                return;
                            }
                            if (!file.createNewFile()) {
                                this.sendStatus(id, 4, "Can not create " + path);
                            }
                            raf = new RandomAccessFile(file, "rw");
                            raf.setLength(0L);
                            break;
                        }
                        case 2: {
                            if (!file.exists()) {
                                if (!file.getParentFile().exists()) {
                                    this.sendStatus(id, 10, path);
                                } else {
                                    this.sendStatus(id, 2, path);
                                }
                                return;
                            }
                            raf = new RandomAccessFile(file, "rw");
                            break;
                        }
                        case 3: {
                            raf = new RandomAccessFile(file, "rw");
                            break;
                        }
                        case 4: {
                            if (!file.exists()) {
                                if (!file.getParentFile().exists()) {
                                    this.sendStatus(id, 10, path);
                                } else {
                                    this.sendStatus(id, 2, path);
                                }
                                return;
                            }
                            raf = new RandomAccessFile(file, "rw");
                            raf.setLength(0L);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported open mode: " + flags);
                        }
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new FileHandle(file, raf, flags));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 4: {
                String handle = buffer.getString();
                try {
                    Handle h = this.handles.get(handle);
                    if (h == null) {
                        this.sendStatus(id, 9, handle, "");
                        break;
                    }
                    this.handles.remove(handle);
                    h.close();
                    this.sendStatus(id, 0, "", "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 5: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                int len = buffer.getInt();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    RandomAccessFile raf = ((FileHandle)p).getRaf();
                    raf.seek(offset);
                    byte[] b = new byte[Math.max(len, 32768)];
                    len = raf.read(b);
                    if (len >= 0) {
                        Buffer buf = new Buffer(len + 5);
                        buf.putByte((byte)103);
                        buf.putInt(id);
                        buf.putBytes(b, 0, len);
                        buf.putBoolean(len == 0);
                        this.send(buf);
                        break;
                    }
                    this.sendStatus(id, 1, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 6: {
                String handle = buffer.getString();
                long offset = buffer.getLong();
                byte[] data = buffer.getBytes();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof FileHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    RandomAccessFile raf = ((FileHandle)p).getRaf();
                    raf.seek(offset);
                    raf.write(data);
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 7: 
            case 17: {
                String path = buffer.getString();
                try {
                    File p = this.resolveFile(path);
                    this.sendAttrs(id, p);
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 8: {
                String handle = buffer.getString();
                try {
                    Handle p = this.handles.get(handle);
                    if (p == null) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    this.sendAttrs(id, p.getFile());
                }
                catch (FileNotFoundException e) {
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 11: {
                String path = buffer.getString();
                try {
                    File p = this.resolveFile(path);
                    if (!p.exists()) {
                        this.sendStatus(id, 2, path);
                        break;
                    }
                    if (!p.isDirectory()) {
                        this.sendStatus(id, 19, path);
                        break;
                    }
                    if (!p.canRead()) {
                        this.sendStatus(id, 3, path);
                        break;
                    }
                    String handle = UUID.randomUUID().toString();
                    this.handles.put(handle, new DirectoryHandle(p));
                    this.sendHandle(id, handle);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 12: {
                String handle = buffer.getString();
                try {
                    Handle p = this.handles.get(handle);
                    if (!(p instanceof DirectoryHandle)) {
                        this.sendStatus(id, 9, handle);
                        break;
                    }
                    if (((DirectoryHandle)p).isDone()) {
                        this.sendStatus(id, 1, "", "");
                        break;
                    }
                    if (!p.getFile().exists()) {
                        this.sendStatus(id, 2, p.getFile().getPath());
                        break;
                    }
                    if (!p.getFile().isDirectory()) {
                        this.sendStatus(id, 19, p.getFile().getPath());
                        break;
                    }
                    if (!p.getFile().canRead()) {
                        this.sendStatus(id, 3, p.getFile().getPath());
                        break;
                    }
                    this.sendName(id, p.getFile().listFiles());
                    ((DirectoryHandle)p).setDone(true);
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 13: {
                String path = buffer.getString();
                try {
                    File p = this.resolveFile(path);
                    if (!p.exists()) {
                        this.sendStatus(id, 2, p.getPath());
                        break;
                    }
                    if (p.isDirectory()) {
                        this.sendStatus(id, 24, p.getPath());
                        break;
                    }
                    if (!p.delete()) {
                        this.sendStatus(id, 4, "Failed to delete file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 14: {
                String path = buffer.getString();
                try {
                    File p = this.resolveFile(path);
                    if (p.exists()) {
                        if (p.isDirectory()) {
                            this.sendStatus(id, 11, p.getPath());
                            break;
                        }
                        this.sendStatus(id, 19, p.getPath());
                        break;
                    }
                    if (!p.mkdir()) {
                        throw new IOException("Error creating dir " + path);
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 15: {
                String path = buffer.getString();
                try {
                    File p = this.resolveFile(path);
                    if (p.isDirectory()) {
                        if (p.exists()) {
                            if (p.listFiles().length == 0) {
                                if (p.delete()) {
                                    this.sendStatus(id, 0, "");
                                    break;
                                }
                                this.sendStatus(id, 4, "Unable to delete directory " + path);
                                break;
                            }
                            this.sendStatus(id, 18, path);
                            break;
                        }
                        this.sendStatus(id, 10, path);
                        break;
                    }
                    this.sendStatus(id, 19, p.getPath());
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 16: {
                String path = buffer.getString();
                if (path.trim().length() == 0) {
                    path = ".";
                }
                try {
                    this.log.info("path=" + path);
                    File p = this.resolveFile(path);
                    this.sendPath(id, path, p);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 2, e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 18: {
                String oldPath = buffer.getString();
                String newPath = buffer.getString();
                try {
                    File o = this.resolveFile(oldPath);
                    File n = this.resolveFile(newPath);
                    if (!o.exists()) {
                        this.sendStatus(id, 2, o.getPath());
                        break;
                    }
                    if (n.exists()) {
                        this.sendStatus(id, 11, n.getPath());
                        break;
                    }
                    if (!o.renameTo(n)) {
                        this.sendStatus(id, 4, "Failed to rename file");
                        break;
                    }
                    this.sendStatus(id, 0, "");
                }
                catch (IOException e) {
                    this.sendStatus(id, 4, e.getMessage());
                }
                break;
            }
            case 9: 
            case 10: {
                this.sendStatus(id, 0, "");
                break;
            }
            default: {
                this.log.error("Received: {}", (Object)type);
                this.sendStatus(id, 8, "Command " + type + " is unsupported or not implemented");
                throw new IllegalStateException();
            }
        }
    }

    protected void sendHandle(int id, String handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)102);
        buffer.putInt(id);
        buffer.putString(handle);
        this.send(buffer);
    }

    protected void sendAttrs(int id, File file) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, file);
        this.send(buffer);
    }

    protected void sendAttrs(int id, File file, int flags) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt(id);
        this.writeAttrs(buffer, file, flags);
        this.send(buffer);
    }

    protected void sendPath(int id, String path, File f) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(1L);
        String normalizedPath = SelectorUtils.normalizePath(path, "/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        buffer.putString(normalizedPath);
        f = this.resolveFile(normalizedPath);
        if (f.getName().length() == 0) {
            f = this.resolveFile(".");
        }
        if (this.version <= 3) {
            buffer.putString(this.getLongName(f));
            buffer.putInt(0L);
        } else {
            buffer.putString(f.getName());
            this.writeAttrs(buffer, f);
        }
        this.send(buffer);
    }

    protected void sendName(int id, File ... files) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt(id);
        buffer.putInt(files.length);
        for (File f : files) {
            buffer.putString(f.getName());
            if (this.version <= 3) {
                buffer.putString(this.getLongName(f));
            } else {
                buffer.putString(f.getName());
            }
            this.writeAttrs(buffer, f);
        }
        this.send(buffer);
    }

    private String getLongName(File f) {
        String username = this.session.getUsername();
        if (username.length() > 8) {
            username = username.substring(0, 8);
        } else {
            for (int i = username.length(); i < 8; ++i) {
                username = username + " ";
            }
        }
        long length = f.length();
        String lengthString = String.format("%1$#8s", length);
        StringBuilder sb = new StringBuilder();
        sb.append(f.isDirectory() ? "d" : "-");
        sb.append(f.canRead() ? "r" : "-");
        sb.append(f.canWrite() ? "w" : "-");
        sb.append("-");
        sb.append(f.canRead() ? "r" : "-");
        sb.append(f.canWrite() ? "w" : "-");
        sb.append("-");
        sb.append(f.canRead() ? "r" : "-");
        sb.append(f.canWrite() ? "w" : "-");
        sb.append("-");
        sb.append(" ");
        sb.append("  1");
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(lengthString);
        sb.append(" ");
        sb.append(SftpSubsystem.getUnixDate(f.lastModified()));
        sb.append(" ");
        sb.append(f.getName());
        return sb.toString();
    }

    protected void writeAttrs(Buffer buffer, File file) throws IOException {
        this.writeAttrs(buffer, file, 0);
    }

    protected void writeAttrs(Buffer buffer, File file, int flags) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (this.version >= 4) {
            long size = file.length();
            String username = this.session.getUsername();
            long lastModif = file.lastModified();
            int p = 0;
            if (file.canRead()) {
                p |= 0x100;
            }
            if (file.canWrite()) {
                p |= 0x80;
            }
            if (file.isFile()) {
                buffer.putInt(4L);
                buffer.putByte((byte)1);
                buffer.putInt(p);
            } else if (file.isDirectory()) {
                buffer.putInt(4L);
                buffer.putByte((byte)2);
                buffer.putInt(p);
            } else {
                buffer.putInt(0L);
                buffer.putByte((byte)5);
            }
        } else {
            int p = 0;
            if (file.isFile()) {
                p |= 0x8000;
            }
            if (file.isDirectory()) {
                p |= 0x4000;
            }
            if (file.canRead()) {
                p |= 0x100;
            }
            if (file.canWrite()) {
                p |= 0x80;
            }
            if (file.isFile()) {
                buffer.putInt(13L);
                buffer.putLong(file.length());
                buffer.putInt(p);
                buffer.putInt(file.lastModified() / 1000L);
                buffer.putInt(file.lastModified() / 1000L);
            } else if (file.isDirectory()) {
                buffer.putInt(12L);
                buffer.putInt(p);
                buffer.putInt(file.lastModified() / 1000L);
                buffer.putInt(file.lastModified() / 1000L);
            } else {
                buffer.putInt(0L);
            }
        }
    }

    protected void sendStatus(int id, int substatus, String msg) throws IOException {
        this.sendStatus(id, substatus, msg, "");
    }

    protected void sendStatus(int id, int substatus, String msg, String lang) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putByte((byte)101);
        buffer.putInt(id);
        buffer.putInt(substatus);
        buffer.putString(msg);
        buffer.putString(lang);
        this.send(buffer);
    }

    protected void send(Buffer buffer) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.out);
        dos.writeInt(buffer.available());
        dos.write(buffer.array(), buffer.rpos(), buffer.available());
        dos.flush();
    }

    public void destroy() {
        this.closed = true;
    }

    private File resolveFile(String path) {
        return new File(this.root, path);
    }

    private static final String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuffer sb = new StringBuffer(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        int day = cal.get(5);
        if (day < 10) {
            sb.append(' ');
        }
        sb.append(day);
        sb.append(' ');
        long sixMonth = 15811200000L;
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > sixMonth) {
            int year = cal.get(1);
            sb.append(' ');
            sb.append(year);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm = cal.get(12);
            if (mm < 10) {
                sb.append('0');
            }
            sb.append(mm);
        }
        return sb.toString();
    }

    protected static class FileHandle
    extends Handle {
        RandomAccessFile raf;
        int flags;

        public FileHandle(File file, RandomAccessFile raf, int flags) {
            super(file);
            this.raf = raf;
            this.flags = flags;
        }

        public RandomAccessFile getRaf() {
            return this.raf;
        }

        public int getFlags() {
            return this.flags;
        }

        public void close() throws IOException {
            this.raf.close();
        }
    }

    protected static class DirectoryHandle
    extends Handle {
        boolean done;

        public DirectoryHandle(File file) {
            super(file);
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }
    }

    protected static abstract class Handle {
        File file;

        public Handle(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Command> {
        private File root;

        public Factory() {
            this(new File("."));
        }

        public Factory(File root) {
            this.root = root;
        }

        @Override
        public Command create() {
            return new SftpSubsystem(this.root);
        }

        @Override
        public String getName() {
            return "sftp";
        }
    }
}

