/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.impl.method.BaseTypeProducer;
import org.exoplatform.services.rest.impl.method.ParameterHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveTypeProducer
extends BaseTypeProducer {
    static final Map<String, Class<?>> PRIMITIVE_TYPES_MAP;
    private static final Map<String, Object> PRIMITIVE_TYPE_DEFAULTS;
    private Class<?> clazz;
    private Object defaultDefaultValue;

    PrimitiveTypeProducer(Class<?> clazz) {
        this.clazz = clazz;
        this.defaultDefaultValue = PRIMITIVE_TYPE_DEFAULTS.get(clazz.getName());
    }

    @Override
    protected Object createValue(String value) throws Exception {
        Class<?> c = PRIMITIVE_TYPES_MAP.get(this.clazz.getName());
        Method method = ParameterHelper.getStringValueOfMethod(c);
        return method.invoke(null, value);
    }

    @Override
    public Object createValue(String param, MultivaluedMap<String, String> values, String defaultValue) throws Exception {
        String value = (String)values.getFirst((Object)param);
        if (value != null) {
            return this.createValue(value);
        }
        if (defaultValue != null) {
            return this.createValue(defaultValue);
        }
        return this.defaultDefaultValue;
    }

    static {
        HashMap<String, Object> m = new HashMap<String, Object>(7);
        m.put("boolean", Boolean.class);
        m.put("byte", Byte.class);
        m.put("short", Short.class);
        m.put("int", Integer.class);
        m.put("long", Long.class);
        m.put("float", Float.class);
        m.put("double", Double.class);
        PRIMITIVE_TYPES_MAP = Collections.unmodifiableMap(m);
        m = new HashMap(7);
        m.put("boolean", false);
        m.put("byte", (byte)0);
        m.put("short", (short)0);
        m.put("int", 0);
        m.put("long", 0L);
        m.put("float", Float.valueOf(0.0f));
        m.put("double", 0.0);
        PRIMITIVE_TYPE_DEFAULTS = Collections.unmodifiableMap(m);
    }
}

