/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContent;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIAddMetadataForm
extends UIDialogForm {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIAddMetadataForm");
    private String nodeType_;

    public UIAddMetadataForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void setNodeType(String nodeType) {
        this.nodeType_ = nodeType;
    }

    public String getNodeType() {
        return this.nodeType_;
    }

    public String getDialogTemplatePath() {
        this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        try {
            return metadataService.getMetadataPath(this.nodeType_, true, this.repositoryName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return null;
        }
    }

    public String getTemplate() {
        return this.getDialogTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIAddMetadataForm> {
        public void execute(Event<UIAddMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIAddMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIAddMetadataForm> {
        public void execute(Event<UIAddMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIAddMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIAddMetadataForm> {
        public void execute(Event<UIAddMetadataForm> event) throws Exception {
            UIUploadContainer uiUploadContainer = (UIUploadContainer)((UIAddMetadataForm)((Object)event.getSource())).getParent();
            uiUploadContainer.removeChild(UIAddMetadataForm.class);
            uiUploadContainer.setRenderedChild(UIUploadContent.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIAddMetadataForm> {
        public void execute(Event<UIAddMetadataForm> event) throws Exception {
            UIAddMetadataForm uiForm = (UIAddMetadataForm)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIUploadContainer uiUploadContainer = (UIUploadContainer)uiForm.getAncestorOfType(UIUploadContainer.class);
            Node node = uiUploadContainer.getEditNode(uiForm.nodeType_);
            NodeTypeManager ntManager = uiJCRExplorer.getSession().getWorkspace().getNodeTypeManager();
            PropertyDefinition[] props = ntManager.getNodeType(uiForm.getNodeType()).getPropertyDefinitions();
            ArrayList<Value> valueList = new ArrayList<Value>();
            try {
                for (PropertyDefinition prop : props) {
                    String name = prop.getName();
                    String inputName = (String)uiForm.fieldNames.get(name);
                    if (prop.isProtected()) continue;
                    int requiredType = prop.getRequiredType();
                    if (prop.isMultiple()) {
                        if (requiredType == 5) {
                            UIFormDateTimeInput uiFormDateTime = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                            valueList.add(uiJCRExplorer.getSession().getValueFactory().createValue(uiFormDateTime.getCalendar()));
                            node.setProperty(name, valueList.toArray(new Value[0]));
                            continue;
                        }
                        if (uiForm.getUIInput(inputName) instanceof UIFormSelectBox) {
                            node.setProperty(name, ((UIFormSelectBox)uiForm.getUIInput(inputName)).getSelectedValues());
                            continue;
                        }
                        List values = ((UIFormMultiValueInputSet)uiForm.getUIInput(inputName)).getValue();
                        node.setProperty(name, values.toArray(new String[values.size()]));
                        continue;
                    }
                    if (requiredType == 6) {
                        UIFormInput uiInput = uiForm.getUIInput(inputName);
                        String value = "false";
                        if (uiInput instanceof UIFormSelectBox) {
                            value = (String)((UIFormSelectBox)uiInput).getValue();
                        }
                        node.setProperty(name, Boolean.parseBoolean(value));
                        continue;
                    }
                    if (requiredType == 5) {
                        UIFormDateTimeInput cal = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                        node.setProperty(name, cal.getCalendar());
                        continue;
                    }
                    if (requiredType != 1) continue;
                    String value = (String)((UIFormStringInput)uiForm.getUIInput(inputName)).getValue();
                    if (value == null) {
                        value = "";
                    }
                    node.setProperty(name, value);
                }
            }
            catch (Exception e) {
                UIUploadManager uiUploadManager = (UIUploadManager)uiUploadContainer.getParent();
                uiUploadManager.initMetadataPopup();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadManager);
            }
            node.save();
            node.getSession().save();
            uiUploadContainer.setRenderedChild(UIUploadContent.class);
            uiUploadContainer.removeChild(UIAddMetadataForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiUploadContainer);
        }
    }
}

