/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class McastTest {
    public static void main(String[] args) {
        byte[] buf = new byte[]{};
        boolean receiver = true;
        InetAddress addr = null;
        int port = 0;
        for (int i = 0; i < args.length; ++i) {
            String val = args[i];
            if ("-help".equals(val)) {
                McastTest.help();
                return;
            }
            if ("-sender".equals(val)) {
                receiver = false;
                continue;
            }
            if ("-receiver".equals(val)) {
                receiver = true;
                try {
                    addr = InetAddress.getByName(args[++i]);
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e);
                    McastTest.help();
                    return;
                }
            }
            McastTest.help();
        }
        try {
            if (receiver) {
                DatagramSocket sock = new DatagramSocket(port, addr);
                System.out.println("Socket=" + sock.getLocalAddress() + ':' + sock.getLocalPort());
                System.out.println("starting as receiver");
                McastTest.receiverLoop(sock);
            } else {
                DatagramSocket sock = new DatagramSocket();
                System.out.println("Socket=" + sock.getLocalAddress() + ':' + sock.getLocalPort());
                System.out.println("starting as sender");
                McastTest.senderLoop(sock);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void receiverLoop(DatagramSocket sock) {
        while (true) {
            byte[] buf = new byte[256];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                sock.receive(packet);
                System.out.println("Receive packet from " + packet.getAddress().getHostAddress() + ':' + packet.getPort() + ": " + new String(packet.getData()));
            }
            catch (Exception e) {
                System.err.println(e);
                return;
            }
        }
    }

    static void senderLoop(DatagramSocket sock) {
        DataInputStream in = new DataInputStream(System.in);
        try {
            while (true) {
                int dst_port;
                InetAddress dst;
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) break;
                StringTokenizer tok = new StringTokenizer(line);
                try {
                    dst = InetAddress.getByName(tok.nextToken());
                    dst_port = Integer.parseInt(tok.nextToken());
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                while (tok.hasMoreTokens()) {
                    String tmp = tok.nextToken();
                    sb.append(tmp + ' ');
                }
                String buf = sb.toString();
                System.out.println("sending " + buf);
                byte[] bbuf = buf.getBytes();
                DatagramPacket packet = new DatagramPacket(bbuf, bbuf.length, dst, dst_port);
                sock.send(packet);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("McastTest [-help] [-sender | -receiver <local addr> <local port>]");
    }
}

