/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class PerformanceTestGenerator {
    Properties configProperties = null;
    private long totalDataBytes;
    private int[] numOfSenders;
    private int[] messageSizes;
    private int numNodes;
    private int interval;

    public PerformanceTestGenerator(Properties config) {
        this.configProperties = config;
    }

    public static void main(String[] args) {
        Properties config = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-config".equals(args[i])) {
                String config_file = args[++i];
                config = new Properties();
                try {
                    config.load(new FileInputStream(config_file));
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.err.println("File " + config_file + " not found");
                    return;
                }
                catch (IOException e) {
                    System.err.println("Error reading configuration file " + config_file);
                    return;
                }
            }
            System.out.println("PerformanceTestGenerator -config <file>");
            return;
        }
        try {
            PerformanceTestGenerator t = new PerformanceTestGenerator(config);
            t.parse();
            t.generateTestConfigFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parse() throws Exception {
        this.numNodes = Integer.parseInt(this.configProperties.getProperty("nodes"));
        this.totalDataBytes = Long.parseLong(this.configProperties.getProperty("total_data"));
        this.numOfSenders = PerformanceTestGenerator.tokenizeAndConvert(this.configProperties.getProperty("number_of_senders"), ",");
        this.messageSizes = PerformanceTestGenerator.tokenizeAndConvert(this.configProperties.getProperty("message_sizes"), ",");
        this.interval = Integer.parseInt(this.configProperties.getProperty("interval"));
    }

    private void generateFile(int numOfSenders, int messageSize, int nodeCount) {
        FileWriter fw = null;
        long numOfMessages = this.totalDataBytes / (long)messageSize;
        try {
            fw = new FileWriter("config_" + numOfSenders + "_" + nodeCount + "_" + messageSize + ".txt");
            fw.write("transport=org.jgroups.tests.perf.transports.JGroupsTransport\n");
            fw.write("msg_size=" + messageSize + "\n");
            fw.write("num_msgs=" + numOfMessages / (long)numOfSenders + "\n");
            fw.write("num_senders=" + numOfSenders + "\n");
            fw.write("num_members=" + nodeCount + "\n");
            fw.write("log_interval=" + this.interval + "\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String[] tokenize(String s, String delim) {
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        if (delim == null || delim.length() == 0) {
            return new String[]{s};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        int pos = 0;
        int delPos = 0;
        while ((delPos = s.indexOf(delim, pos)) != -1) {
            tokens.add(s.substring(pos, delPos));
            pos = delim.length() + delPos;
        }
        tokens.add(s.substring(pos));
        return tokens.toArray(new String[tokens.size()]);
    }

    public static int[] tokenizeAndConvert(String s, String delim) {
        String[] stokens = PerformanceTestGenerator.tokenize(s, delim);
        int[] result = new int[stokens.length];
        for (int i = 0; i < stokens.length; ++i) {
            result[i] = Integer.parseInt(stokens[i]);
        }
        return result;
    }

    private void generateTestConfigFiles() {
        for (int i = 0; i < this.numOfSenders.length; ++i) {
            for (int j = 0; j < this.messageSizes.length; ++j) {
                this.generateFile(this.numOfSenders[i], this.messageSizes[j], this.numNodes);
            }
        }
    }
}

