/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.jbpm.ant.AntHelper;

public class HibernatePropertiesTask
extends Task {
    private String config;
    private String prefix;
    private Pattern includes;
    private Pattern excludes;

    public void execute() throws BuildException {
        this.log("loading hibernate properties from " + this.config);
        Configuration configuration = AntHelper.getConfiguration(this.config, null);
        Properties properties = configuration.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        StringBuffer nameBuf = new StringBuffer(this.prefix);
        int prefixLength = this.prefix.length();
        Project project = this.getProject();
        Iterator<Map.Entry<Object, Object>> i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> property = i.next();
            String name = (String)property.getKey();
            if (!this.include(name) || this.exclude(name)) continue;
            name = nameBuf.append(name).toString();
            String value = (String)property.getValue();
            this.log("setting '" + name + "' to: " + value);
            project.setNewProperty(name, value);
            nameBuf.setLength(prefixLength);
        }
    }

    private boolean include(String name) {
        return this.includes == null || this.includes.matcher(name).matches();
    }

    private boolean exclude(String name) {
        return this.excludes != null && this.excludes.matcher(name).matches();
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setIncludes(String regex) {
        this.includes = Pattern.compile(regex);
    }

    public void setExcludes(String regex) {
        this.excludes = Pattern.compile(regex);
    }
}

