/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.persistence.JbpmPersistenceException;

public class GraphSession {
    final Session session;
    final JbpmSession jbpmSession;
    private static final Log log = LogFactory.getLog((Class)GraphSession.class);

    public GraphSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public GraphSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        String processDefinitionName = processDefinition.getName();
        if (processDefinitionName != null) {
            ProcessDefinition previousLatestVersion = this.findLatestProcessDefinition(processDefinitionName);
            if (previousLatestVersion != null) {
                processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
            } else {
                processDefinition.setVersion(1);
            }
        } else {
            throw new JbpmException("process definition does not have a name");
        }
        this.session.save((Object)processDefinition);
    }

    public void saveProcessDefinition(ProcessDefinition processDefinition) {
        try {
            this.session.save((Object)processDefinition);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not save " + processDefinition, e);
        }
    }

    public ProcessDefinition loadProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.load(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.get(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition findProcessDefinition(String name, int version) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findProcessDefinitionByNameAndVersion").setString("name", name).setInteger("version", version).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process definition '" + name + "' at version " + version, e);
        }
    }

    public ProcessDefinition findLatestProcessDefinition(String name) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findLatestProcessDefinitionQuery").setString("name", name).setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process definition '" + name + "'", e);
        }
    }

    public List findLatestProcessDefinitions() {
        try {
            List tuples = this.session.getNamedQuery("GraphSession.findLatestProcessDefinitions").list();
            ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>();
            Iterator i = tuples.iterator();
            while (i.hasNext()) {
                Object[] tuple = (Object[])i.next();
                String name = (String)tuple[0];
                Integer version = (Integer)tuple[1];
                result.add(this.findProcessDefinition(name, version));
            }
            return result;
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find latest versions of process definitions", e);
        }
    }

    public List findProcessDefinitions(Collection processDefinitionIds) {
        return this.session.createCriteria(ProcessDefinition.class).add(Restrictions.in((String)"id", (Collection)processDefinitionIds)).list();
    }

    public List findAllProcessDefinitions() {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessDefinitions").list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find all process definitions", e);
        }
    }

    public List findAllProcessDefinitionVersions(String name) {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessDefinitionVersions").setString("name", name).list();
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmPersistenceException("could not find all versions of process definition '" + name + "'", e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) {
        this.deleteProcessDefinition(this.loadProcessDefinition(processDefinitionId));
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition) {
        try {
            List processInstanceIds = this.session.getNamedQuery("GraphSession.findAllProcessInstanceIdsForDefinition").setLong("processDefinitionId", processDefinition.getId()).list();
            Iterator i = processInstanceIds.iterator();
            while (i.hasNext()) {
                Long processInstanceId = (Long)i.next();
                ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
                if (processInstance != null) {
                    this.deleteProcessInstance(processInstance);
                    continue;
                }
                log.debug((Object)("process instance " + processInstanceId + " has been deleted already"));
            }
            List referencingProcessStates = this.findReferencingProcessStates(processDefinition);
            Iterator i2 = referencingProcessStates.iterator();
            while (i2.hasNext()) {
                ProcessState processState = (ProcessState)i2.next();
                processState.setSubProcessDefinition(null);
            }
            this.session.delete((Object)processDefinition);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not delete " + processDefinition, e);
        }
    }

    List findReferencingProcessStates(ProcessDefinition subProcessDefinition) {
        return this.session.getNamedQuery("GraphSession.findReferencingProcessStates").setEntity("subProcessDefinition", (Object)subProcessDefinition).list();
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        throw new UnsupportedOperationException("use JbpmContext.save(ProcessInstance) instead");
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load process instance " + processInstanceId, e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process instance " + processInstanceId, e);
        }
    }

    public Token loadToken(long tokenId) {
        try {
            return (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not load token " + tokenId, e);
        }
    }

    public Token getToken(long tokenId) {
        try {
            return (Token)this.session.get(Token.class, (Serializable)new Long(tokenId));
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get token " + tokenId, e);
        }
    }

    public void lockProcessInstance(long processInstanceId) {
        try {
            this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId), LockMode.UPGRADE);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not lock process instance " + processInstanceId, e);
        }
    }

    public void lockProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.lock((Object)processInstance, LockMode.UPGRADE);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not lock " + processInstance, e);
        }
    }

    public List findProcessInstances(long processDefinitionId) {
        try {
            return this.session.getNamedQuery("GraphSession.findAllProcessInstancesForDefinition").setLong("processDefinitionId", processDefinitionId).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find process instances for process definition " + processDefinitionId, e);
        }
    }

    public void deleteProcessInstance(long processInstanceId) {
        this.deleteProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.deleteProcessInstance(processInstance, true, true);
    }

    public void deleteProcessInstance(ProcessInstance processInstance, boolean includeTasks, boolean includeJobs) {
        if (processInstance == null) {
            throw new IllegalArgumentException("processInstance cannot be null");
        }
        try {
            if (includeJobs) {
                this.deleteJobs(processInstance);
            }
            this.deleteLogs(processInstance);
            Token superProcessToken = processInstance.getSuperProcessToken();
            if (superProcessToken != null) {
                this.detachFromSuperProcess(processInstance, superProcessToken);
            }
            this.deleteSubProcesses(processInstance);
            if (includeTasks) {
                this.deleteTasks(processInstance);
            }
            log.debug((Object)("deleting " + processInstance));
            this.session.delete((Object)processInstance);
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not delete " + processInstance, e);
        }
    }

    void deleteJobs(ProcessInstance processInstance) {
        log.debug((Object)("deleting jobs for " + processInstance));
        int entityCount = this.session.getNamedQuery("GraphSession.deleteJobsForProcessInstance").setEntity("processInstance", (Object)processInstance).executeUpdate();
        log.debug((Object)("deleted " + entityCount + " jobs for " + processInstance));
    }

    void deleteLogs(ProcessInstance processInstance) {
        log.debug((Object)("deleting logs for " + processInstance));
        List logs = this.session.getNamedQuery("GraphSession.findLogsForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        Iterator i = logs.iterator();
        while (i.hasNext()) {
            this.session.delete(i.next());
        }
    }

    void detachFromSuperProcess(ProcessInstance processInstance, Token superProcessToken) {
        log.debug((Object)("detaching " + processInstance + " from " + superProcessToken));
        processInstance.setSuperProcessToken(null);
        superProcessToken.setSubProcessInstance(null);
    }

    void deleteSubProcesses(ProcessInstance processInstance) {
        log.debug((Object)("deleting subprocesses for " + processInstance));
        List subProcessInstances = this.session.getNamedQuery("GraphSession.findSubProcessInstances").setEntity("processInstance", (Object)processInstance).list();
        if (subProcessInstances.isEmpty()) {
            log.debug((Object)("no subprocesses to delete for " + processInstance));
            return;
        }
        Iterator i = subProcessInstances.iterator();
        while (i.hasNext()) {
            ProcessInstance subProcessInstance = (ProcessInstance)i.next();
            log.debug((Object)("preparing to delete Sub" + subProcessInstance));
            this.deleteProcessInstance(subProcessInstance);
        }
    }

    void deleteTasks(ProcessInstance processInstance) {
        log.debug((Object)("deleting tasks for " + processInstance));
        List tasks = this.session.getNamedQuery("GraphSession.findTaskInstancesForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        Iterator i = tasks.iterator();
        while (i.hasNext()) {
            this.session.delete(i.next());
        }
    }

    public List calculateAverageTimeByNode(long processDefinitionId, long minumumDurationMillis) {
        try {
            ArrayList<AverageNodeTimeEntry> results;
            List tuples = this.session.getNamedQuery("GraphSession.calculateAverageTimeByNode").setLong("processDefinitionId", processDefinitionId).setDouble("minimumDuration", (double)minumumDurationMillis).list();
            if (!tuples.isEmpty()) {
                results = new ArrayList<AverageNodeTimeEntry>();
                Iterator i = tuples.iterator();
                while (i.hasNext()) {
                    Object[] values = (Object[])i.next();
                    AverageNodeTimeEntry averageNodeTimeEntry = new AverageNodeTimeEntry();
                    averageNodeTimeEntry.setNodeId(((Number)values[0]).longValue());
                    averageNodeTimeEntry.setNodeName((String)values[1]);
                    averageNodeTimeEntry.setCount(((Number)values[2]).intValue());
                    averageNodeTimeEntry.setAverageDuration(((Number)values[3]).longValue());
                    averageNodeTimeEntry.setMinDuration(((Number)values[4]).longValue());
                    averageNodeTimeEntry.setMaxDuration(((Number)values[5]).longValue());
                    results.add(averageNodeTimeEntry);
                }
            } else {
                results = Collections.EMPTY_LIST;
            }
            return results;
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not calculate average time by node for " + processDefinitionId, e);
        }
    }

    public List findActiveNodesByProcessInstance(ProcessInstance processInstance) {
        try {
            return this.session.getNamedQuery("GraphSession.findActiveNodesByProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not find active nodes for " + processInstance, e);
        }
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        try {
            return (ProcessInstance)this.session.getNamedQuery("GraphSession.findProcessInstanceByKey").setEntity("processDefinition", (Object)processDefinition).setString("key", key).uniqueResult();
        }
        catch (HibernateException e) {
            this.handle(e);
            throw new JbpmPersistenceException("could not get process instance with key '" + key + "'", e);
        }
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getProcessInstance(processDefinition, key);
        if (processInstance == null) {
            throw new JbpmException("no process instance was found with key '" + key + "'");
        }
        return processInstance;
    }

    private void handle(HibernateException exception) {
        log.debug((Object)exception);
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }

    public static class AverageNodeTimeEntry {
        private long nodeId;
        private String nodeName;
        private int count;
        private long averageDuration;
        private long minDuration;
        private long maxDuration;

        public long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getAverageDuration() {
            return this.averageDuration;
        }

        public void setAverageDuration(long averageDuration) {
            this.averageDuration = averageDuration;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public void setMinDuration(long minDuration) {
            this.minDuration = minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public void setMaxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
        }
    }
}

