/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.ecm.connector.fckeditor.FCKMessage;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUploadHandler {
    public static final String UPLOAD_ACTION = "upload".intern();
    public static final String PROGRESS_ACTION = "progress".intern();
    public static final String ABORT_ACTION = "abort".intern();
    public static final String DELETE_ACTION = "delete".intern();
    public static final String SAVE_ACTION = "save".intern();
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private UploadService uploadService = (UploadService)WCMCoreUtils.getService(UploadService.class);
    private FCKMessage fckMessage = new FCKMessage();

    @Deprecated
    public Response upload(String uploadId, String contentType, double contentLength, InputStream inputStream, Node currentNode, String language, int limit) throws Exception {
        this.uploadService.addUploadLimit(uploadId, Integer.valueOf(limit));
        this.uploadService.createUploadResource(uploadId, null, contentType, contentLength, inputStream);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response upload(HttpServletRequest servletRequest, String uploadId, Integer limit) throws Exception {
        this.uploadService.addUploadLimit(uploadId, limit);
        this.uploadService.createUploadResource(servletRequest);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).build();
    }

    public Response control(String uploadId, String action) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (PROGRESS_ACTION.equals(action)) {
            Document currentProgress = this.getProgress(uploadId);
            return Response.ok((Object)new DOMSource(currentProgress), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (ABORT_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (DELETE_ACTION.equals(action)) {
            this.uploadService.removeUploadResource(uploadId);
            return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        return Response.status((int)400).cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    public Response saveAsNTFile(Node parent, String uploadId, String fileName, String language, String siteName, String userId) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        if (parent == null) {
            Document fileNotUploaded = this.fckMessage.createMessage(204, FCKMessage.ERROR, language, null);
            return Response.ok((Object)new DOMSource(fileNotUploaded), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (!FCKUtils.hasAddNodePermission(parent)) {
            Object[] args = new Object[]{parent.getPath()};
            Document message = this.fckMessage.createMessage(203, FCKMessage.ERROR, language, args);
            return Response.ok((Object)new DOMSource(message), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        if (fileName == null || fileName.length() == 0) {
            fileName = resource.getFileName();
        }
        if (parent.hasNode(fileName)) {
            Object[] args = new Object[]{fileName, parent.getPath()};
            Document fileExisted = this.fckMessage.createMessage(201, FCKMessage.ERROR, language, args);
            return Response.ok((Object)new DOMSource(fileExisted), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
        String location = resource.getStoreLocation();
        byte[] uploadData = IOUtil.getFileContentAsBytes((String)location);
        Node file = parent.addNode(fileName, FCKUtils.NT_FILE);
        Node jcrContent = file.addNode("jcr:content", "nt:resource");
        MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
        String mimetype = mimeTypeResolver.getMimeType(resource.getFileName());
        jcrContent.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(uploadData));
        jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        jcrContent.setProperty("jcr:mimeType", mimetype);
        parent.getSession().save();
        parent.getSession().refresh(true);
        this.uploadService.removeUploadResource(uploadId);
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        wcmPublicationService.updateLifecyleOnChangeContent(file, siteName, userId);
        return Response.ok(null, (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Document getProgress(String uploadId) throws Exception {
        UploadResource resource = this.uploadService.getUploadResource(uploadId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        if (resource == null) {
            return doc;
        }
        Double percent = 0.0;
        percent = resource.getStatus() == 0 ? Double.valueOf(resource.getUploadedSize() * 100.0 / resource.getEstimatedSize()) : Double.valueOf(100.0);
        Element rootElement = doc.createElement("UploadProgress");
        rootElement.setAttribute("uploadId", uploadId);
        rootElement.setAttribute("fileName", resource.getFileName());
        rootElement.setAttribute("percent", percent.intValue() + "");
        doc.appendChild(rootElement);
        return doc;
    }
}

