/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XHTMLSerializer;
import org.owasp.validator.html.Policy;

public class ASXHTMLSerializer
extends XHTMLSerializer {
    private boolean encodeAllPossibleEntities;
    private String[] allowedEmptyTags;

    public ASXHTMLSerializer(Writer w, OutputFormat format, Policy policy) {
        super(w, format);
        this.allowedEmptyTags = policy.getAllowedEmptyTags();
        this.encodeAllPossibleEntities = "true".equals(policy.getDirective("entityEncodeIntlChars"));
    }

    protected String getEntityRef(int charToPrint) {
        if (this.encodeAllPossibleEntities || "<>\"'&".indexOf(charToPrint) != -1) {
            return super.getEntityRef(charToPrint);
        }
        return null;
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty && this.isAllowedEmptyTag(rawName)) {
            this._printer.printText(" />");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName.toLowerCase(Locale.ENGLISH));
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        if (rawName == null || !rawName.equalsIgnoreCase("A") && !rawName.equalsIgnoreCase("TD")) {
            state.afterElement = true;
        }
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    private boolean isAllowedEmptyTag(String tagName) {
        boolean allowed = false;
        for (int i = 0; i < this.allowedEmptyTags.length; ++i) {
            if (!this.allowedEmptyTags[i].equalsIgnoreCase(tagName)) continue;
            allowed = true;
            i = this.allowedEmptyTags.length;
        }
        return allowed;
    }
}

