/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class PortletPreferenceMigrationService
implements Startable {
    private static final String MOP_PORTLET_PREFERENCE = "mop:portletpreference";
    private Log log = ExoLogger.getLogger(this.getClass());
    private RepositoryService repoService;

    public PortletPreferenceMigrationService(RepositoryService repositoryService) {
        this.repoService = repositoryService;
    }

    public void start() {
        this.upgradePortletPreference("searches/WCMAdvanceSearchPortlet", "basePath", "detail");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePortletPreference(String portletName, String prefName, String prefValue) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository repository = this.repoService.getCurrentRepository();
            Session session = sessionProvider.getSession("portal-system", repository);
            QueryManager manager = session.getWorkspace().getQueryManager();
            String statement = "SELECT * from mop:workspaceclone WHERE mop:contentid='" + portletName + "' and fn:name() = 'mop:customization'";
            Query query = manager.createQuery(statement.toString(), "sql");
            NodeIterator nodes = query.execute().getNodes();
            while (nodes.hasNext()) {
                Node stateNode;
                Node node = (Node)nodes.next();
                if (!node.hasNode("mop:state") || !(stateNode = node.getNode("mop:state")).isNodeType("mop:portletpreferences")) continue;
                this.addNode(stateNode, "mop:" + prefName, prefValue);
                stateNode.save();
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("An unexpected problem occurs when adding preference " + prefName + " for portlet " + portletName), (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    private void addNode(Node stateNode, String nodeName, String value) {
        block3: {
            try {
                Node prefNode = stateNode.hasNode(nodeName) ? stateNode.getNode(nodeName) : stateNode.addNode(nodeName, MOP_PORTLET_PREFERENCE);
                prefNode.setProperty("mop:value", new String[]{value});
                prefNode.setProperty("mop:readonly", false);
                stateNode.save();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Add :: mop:portletpreference :: " + nodeName + " :-: " + value + " ::" + stateNode.getPath()));
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error((Object)("An unexpected problem occurs when adding preference " + nodeName + " for portlet "), (Throwable)e);
            }
        }
    }

    public void stop() {
    }
}

