/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DELAY_JOIN_REQ;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class JoinTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;

    public JoinTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel("A");
        this.c2 = this.createChannel("A");
    }

    public void tearDown() throws Exception {
        if (this.c2 != null) {
            this.c2.close();
        }
        if (this.c1 != null) {
            this.c1.close();
        }
        super.tearDown();
    }

    public void testSingleJoin() throws ChannelException {
        this.c1.connect("X");
        View v = this.c1.getView();
        JoinTest.assertNotNull((Object)v);
        JoinTest.assertEquals((int)1, (int)v.size());
    }

    public void testJoinsOnTwoChannels() throws ChannelException {
        this.c1.connect("X");
        this.c2.connect("X");
        JoinTest.blockUntilViewsReceived(this.c1, 2, 1000L);
        JoinTest.blockUntilViewsReceived(this.c2, 2, 1000L);
        View v1 = this.c1.getView();
        View v2 = this.c2.getView();
        System.out.println("v1=" + v1 + ", v2=" + v2);
        JoinTest.assertNotNull((Object)v1);
        JoinTest.assertNotNull((Object)v2);
        JoinTest.assertEquals((int)2, (int)v1.size());
        JoinTest.assertEquals((int)2, (int)v2.size());
        JoinTest.assertEquals((Object)v1, (Object)v2);
    }

    public void testJoinsOnTwoChannelsAndSend() throws ChannelException {
        MyReceiver r1 = new MyReceiver("c1");
        MyReceiver r2 = new MyReceiver("c2");
        this.c1.setReceiver(r1);
        this.c2.setReceiver(r2);
        Message m1 = new Message(null, null, (Serializable)((Object)"message-1"));
        Message m2 = new Message(null, null, (Serializable)((Object)"message-2"));
        this.c1.connect("X");
        View view = this.c1.getView();
        JoinTest.assertEquals((String)("c1's view: " + view), (int)1, (int)view.size());
        this.c2.connect("X");
        view = this.c2.getView();
        JoinTest.assertEquals((String)("c2's view: " + view), (int)2, (int)view.size());
        Util.sleep(200L);
        view = this.c1.getView();
        JoinTest.assertEquals((String)("c1's view: " + view), (int)2, (int)view.size());
        this.c1.send(m1);
        this.c2.send(m2);
        Util.sleep(1500L);
        List c1_list = r1.getMsgs();
        List c2_list = r2.getMsgs();
        System.out.println("c1: " + c1_list.size() + " msgs, c2: " + c2_list.size() + " msgs");
        JoinTest.assertNotNull((Object)c1_list);
        JoinTest.assertNotNull((Object)c2_list);
        JoinTest.assertEquals((String)("cl_list: " + c1_list), (int)2, (int)c1_list.size());
        JoinTest.assertEquals((String)("c2_list: " + c2_list), (int)2, (int)c2_list.size());
        JoinTest.assertTrue((boolean)c1_list.contains("message-1"));
        JoinTest.assertTrue((boolean)c2_list.contains("message-1"));
        JoinTest.assertTrue((boolean)c1_list.contains("message-2"));
        JoinTest.assertTrue((boolean)c2_list.contains("message-2"));
    }

    public void testDelayedJoinResponse() throws Exception {
        long JOIN_TIMEOUT = 2000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 2000L, 4000L, 1000L);
    }

    public void testDelayedJoinResponse2() throws Exception {
        long JOIN_TIMEOUT = 2000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 2000L, 4000L, 1000L);
    }

    public void testDelayedJoinResponse3() throws Exception {
        long JOIN_TIMEOUT = 5000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 5000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(5000L, 5000L, 4000L, 1000L);
    }

    public void testDelayedJoinResponse4() throws Exception {
        long JOIN_TIMEOUT = 1000L;
        long DELAY_JOIN_REQ2 = 4000L;
        long DISCOVERY_TIMEOUT = 2000L;
        long TOLERANCE = 1000L;
        this._testDelayedJoinResponse(2000L, 1000L, 4000L, 1000L);
    }

    public void _testDelayedJoinResponse(long discovery_timeout, long join_timeout, long delay_join_req, long tolerance) throws Exception {
        Discovery discovery;
        this.c1.connect("x");
        ProtocolStack stack = this.c2.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol("GMS");
        if (gms != null) {
            gms.setJoinTimeout(join_timeout);
        }
        if ((discovery = (Discovery)stack.findProtocol(Discovery.class)) != null) {
            discovery.setNumInitialMembers(10);
            discovery.setTimeout(discovery_timeout);
        }
        stack = this.c1.getProtocolStack();
        DELAY_JOIN_REQ delay = new DELAY_JOIN_REQ();
        delay.setDelay(delay_join_req);
        stack.insertProtocol((Protocol)delay, 2, "GMS");
        System.out.println(new Date() + ": joining c2");
        long start = System.currentTimeMillis();
        this.c2.connect("x");
        long stop = System.currentTimeMillis();
        long join_time = stop - start;
        long tolerated_join_time = discovery_timeout + delay_join_req + tolerance;
        System.out.println(new Date() + ": joining of c2 took " + join_time + " ms (should have taken not more than " + tolerated_join_time + " ms)");
        JoinTest.assertTrue((String)("join time (" + join_time + ") was > tolerated join time (" + tolerated_join_time + ")"), (join_time <= tolerated_join_time ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(JoinTest.class);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final String name;
        private final List<String> msgs;

        public MyReceiver(String name) {
            this.name = name;
            this.msgs = Collections.synchronizedList(new ArrayList());
        }

        public List getMsgs() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        public void receive(Message msg) {
            String s = (String)msg.getObject();
            this.msgs.add(s);
            System.out.println("[" + this.name + "] received " + s + " from " + msg.getSrc());
        }

        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + "] view: " + new_view);
        }
    }
}

