/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Version;

public class VersionTest
extends TestCase {
    public VersionTest(String s) {
        super(s);
    }

    public void testVersionPrint() {
        System.out.println("version is " + Version.printVersion());
        VersionTest.assertTrue((boolean)true);
    }

    public void testNullVersion() {
        VersionTest.assertFalse((boolean)Version.isSame((short)0));
    }

    public void testDifferentLengthVersion1() {
        short version2 = Version.encode(2, 0, 7);
        VersionTest.assertFalse((boolean)Version.isSame(version2));
    }

    public void testDifferentVersion() {
        short version2;
        short version1 = Version.encode(2, 0, 7);
        VersionTest.assertFalse((version1 == (version2 = Version.encode(2, 0, 6)) ? 1 : 0) != 0);
    }

    public void testSameVersion() {
        VersionTest.assertTrue((boolean)this.match(0, 0, 1, 0, 0, 1));
        VersionTest.assertTrue((boolean)this.match(1, 0, 0, 1, 0, 0));
        VersionTest.assertTrue((boolean)this.match(10, 2, 60, 10, 2, 60));
        VersionTest.assertFalse((boolean)this.match(1, 2, 3, 1, 2, 0));
        VersionTest.assertFalse((boolean)this.match(0, 0, 0, 0, 0, 1));
        VersionTest.assertFalse((boolean)this.match(2, 5, 0, 2, 5, 1));
    }

    public void testBinaryCompatibility() {
        VersionTest.assertTrue((boolean)this.isBinaryCompatible(0, 0, 0, 0, 0, 0));
        VersionTest.assertTrue((boolean)this.isBinaryCompatible(1, 2, 0, 1, 2, 1));
        VersionTest.assertTrue((boolean)this.isBinaryCompatible(1, 2, 0, 1, 2, 60));
        VersionTest.assertFalse((boolean)this.isBinaryCompatible(2, 5, 0, 2, 4, 1));
        VersionTest.assertFalse((boolean)this.isBinaryCompatible(2, 5, 0, 2, 6, 0));
    }

    private boolean match(int major_1, int minor_1, int micro_1, int major_2, int minor_2, int micro_2) {
        short version2;
        short version1 = Version.encode(major_1, minor_1, micro_1);
        return version1 == (version2 = Version.encode(major_2, minor_2, micro_2));
    }

    private boolean isBinaryCompatible(int major_1, int minor_1, int micro_1, int major_2, int minor_2, int micro_2) {
        short version1 = Version.encode(major_1, minor_1, micro_1);
        short version2 = Version.encode(major_2, minor_2, micro_2);
        boolean retval = Version.isBinaryCompatible(version1, version2);
        System.out.println(Version.print(version1) + " binary compatibel to " + Version.print(version2) + (retval ? " OK" : " FAIL"));
        return Version.isBinaryCompatible(version1, version2);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{VersionTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

