/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingChangesLog {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.PendingChangesLog");
    private static final int SLEEP_TIME = 5;
    private TransactionChangesLog itemDataChangesLog;
    private List<InputStream> listInputStream;
    private List<RandomAccessFile> listRandomAccessFile;
    private int containerType;
    private List<FixupStream> listFixupStream;
    private List<File> listFile;
    private String identifier;
    private FileCleaner fileCleaner;
    private byte[] data;
    private final File tempDir;

    public PendingChangesLog(TransactionChangesLog itemDataChangesLog, FileCleaner fileCleaner) throws IOException {
        this.itemDataChangesLog = itemDataChangesLog;
        this.listInputStream = new ArrayList<InputStream>();
        this.listFixupStream = new ArrayList<FixupStream>();
        this.containerType = this.analysisItemDataChangesLog();
        this.listFile = new ArrayList<File>();
        this.identifier = IdGenerator.generate();
        this.fileCleaner = fileCleaner;
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    public PendingChangesLog(TransactionChangesLog itemDataChangesLog, String identifier, int type, FileCleaner fileCleaner) throws IOException {
        this.itemDataChangesLog = itemDataChangesLog;
        this.listInputStream = new ArrayList<InputStream>();
        this.listFixupStream = new ArrayList<FixupStream>();
        this.listRandomAccessFile = new ArrayList<RandomAccessFile>();
        this.listFile = new ArrayList<File>();
        this.identifier = identifier;
        this.containerType = type;
        this.fileCleaner = fileCleaner;
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    public PendingChangesLog(String identifier, int dataLength) {
        this.identifier = identifier;
        this.data = new byte[dataLength];
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    public PendingChangesLog(TransactionChangesLog transactionChangesLog, List<FixupStream> listFixupStreams, List<File> listFiles, FileCleaner fileCleaner) {
        this.itemDataChangesLog = transactionChangesLog;
        this.listFixupStream = listFixupStreams;
        this.listFile = listFiles;
        this.fileCleaner = fileCleaner;
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
    }

    public void putData(int offset, byte[] tempData) {
        for (int i = 0; i < tempData.length; ++i) {
            this.data[i + offset] = tempData[i];
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public TransactionChangesLog getItemDataChangesLog() {
        return this.itemDataChangesLog;
    }

    public List<InputStream> getInputStreams() {
        return this.listInputStream;
    }

    public List<RandomAccessFile> getListRandomAccessFiles() {
        return this.listRandomAccessFile;
    }

    public List<File> getListFile() {
        return this.listFile;
    }

    public List<FixupStream> getFixupStreams() {
        return this.listFixupStream;
    }

    private int analysisItemDataChangesLog() throws IOException {
        int itemDataChangesLogType = 1;
        int i = 0;
        for (ItemState itemState : this.itemDataChangesLog.getAllStates()) {
            PersistedPropertyData propertyData;
            ItemData itemData = itemState.getData();
            if (itemData instanceof PersistedPropertyData && (propertyData = (PersistedPropertyData)itemData).getValues() != null) {
                for (int j = 0; j < propertyData.getValues().size(); ++j) {
                    if (((ValueData)propertyData.getValues().get(j)).isByteArray()) continue;
                    this.listFixupStream.add(new FixupStream(i, j));
                    InputStream inputStream = itemState.isDeleted() ? new ByteArrayInputStream("".getBytes()) : ((ValueData)propertyData.getValues().get(j)).getAsStream();
                    this.listInputStream.add(inputStream);
                    itemDataChangesLogType = 2;
                }
            }
            ++i;
        }
        return itemDataChangesLogType;
    }

    public int getConteinerType() {
        return this.containerType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static byte[] getAsByteArray(TransactionChangesLog dataChangesLog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(dataChangesLog);
        byte[] bArray = os.toByteArray();
        return bArray;
    }

    public static TransactionChangesLog getAsItemDataChangesLog(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(is);
        TransactionChangesLog objRead = (TransactionChangesLog)ois.readObject();
        return objRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessFile getRandomAccessFile(FixupStream fs) throws IOException {
        int i = 0;
        try {
            for (i = 0; i < this.listFixupStream.size(); ++i) {
                if (!this.listFixupStream.get(i).compare(fs)) continue;
                return this.listRandomAccessFile.get(i);
            }
        }
        catch (IndexOutOfBoundsException e) {
            try {
                Thread.sleep(5L);
                return this.listRandomAccessFile.get(i);
            }
            catch (InterruptedException ie) {
                log.error("The interrupted exceptio : ", ie);
            }
            catch (IndexOutOfBoundsException ioobe) {
                if (log.isDebugEnabled()) {
                    log.info("listFixupStream.size() == " + this.listFixupStream.size());
                    log.info("listRandomAccessFile.size() == " + this.listRandomAccessFile.size());
                    log.info(" i == " + i);
                }
                PendingChangesLog pendingChangesLog = this;
                synchronized (pendingChangesLog) {
                    if (this.listFile.size() > i) {
                        this.listFile.remove(i);
                    }
                    this.listFixupStream.remove(i);
                    this.addNewStream(fs);
                    this.getRandomAccessFile(fs);
                }
            }
        }
        return null;
    }

    public void addNewStream(FixupStream fs) throws IOException {
        this.getFixupStreams().add(fs);
        SpoolFile f = SpoolFile.createTempFile((String)("tempFile" + IdGenerator.generate()), (String)".tmp", (File)this.tempDir);
        this.getListFile().add((File)f);
        this.getListRandomAccessFiles().add(new RandomAccessFile((File)f, "rw"));
    }

    public void restore() throws IOException {
        int i;
        List listItemState = this.itemDataChangesLog.getAllStates();
        for (i = 0; i < this.listFixupStream.size(); ++i) {
            ItemState itemState = (ItemState)listItemState.get(this.listFixupStream.get(i).getItemSateId());
            ItemData itemData = itemState.getData();
            PersistedPropertyData propertyData = (PersistedPropertyData)itemData;
            ValueData vd = (ValueData)propertyData.getValues().get(this.listFixupStream.get(i).getValueDataId());
            propertyData.getValues().set(this.listFixupStream.get(i).getValueDataId(), new StreamPersistedValueData(vd.getOrderNumber(), (File)new SpoolFile(this.listFile.get(i).getAbsolutePath())));
        }
        if (this.listRandomAccessFile != null) {
            for (i = 0; i < this.listRandomAccessFile.size(); ++i) {
                this.listRandomAccessFile.get(i).close();
            }
        }
        for (i = 0; i < this.listFile.size(); ++i) {
            this.fileCleaner.addFile(this.listFile.get(i));
        }
    }

    public final class Type {
        public static final int CHANGESLOG_WITHOUT_STREAM = 1;
        public static final int CHANGESLOG_WITH_STREAM = 2;

        private Type() {
        }
    }
}

