/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.social.core.oauth.OAuthAuthenticationHandler;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.monitor.jvm.J2EEServerInfo;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;
import org.exoplatform.social.opensocial.auth.RestPortalContainerNameConfig;

public class ExoOAuthAuthenticationHandler
extends OAuthAuthenticationHandler {
    private String portalContainerName;

    @Inject
    public ExoOAuthAuthenticationHandler(OAuthDataStore store, @Named(value="shindig.oauth.legacy-body-signing") boolean allowLegacyBodySigning) {
        super(store, allowLegacyBodySigning);
    }

    public String getName() {
        return super.getName();
    }

    public String getPortalContainerName() {
        if (this.portalContainerName == null) {
            RestPortalContainerNameConfig containerNameConfigRest = (RestPortalContainerNameConfig)((Object)PortalContainer.getInstance().getComponentInstanceOfType(RestPortalContainerNameConfig.class));
            this.portalContainerName = containerNameConfigRest.getContainerName();
        }
        return this.portalContainerName;
    }

    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        String domain;
        String portalContainer;
        BasicBlobCrypter crypter;
        SecurityToken securityToken = super.getSecurityTokenFromRequest(request);
        try {
            String keyFile = this.getKeyFilePath();
            crypter = new BasicBlobCrypter(new File(keyFile));
            crypter.timeSource = new TimeSource();
            portalContainer = this.getPortalContainerName();
            domain = securityToken.getDomain();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ExoBlobCrypterSecurityToken crypterSecurityToken = new ExoBlobCrypterSecurityToken((BlobCrypter)crypter, portalContainer, domain);
        crypterSecurityToken.setOwnerId(securityToken.getOwnerId());
        crypterSecurityToken.setAppUrl(securityToken.getAppUrl());
        crypterSecurityToken.setViewerId(securityToken.getViewerId());
        crypterSecurityToken.setPortalContainer(portalContainer);
        return crypterSecurityToken;
    }

    public String getWWWAuthenticateHeader(String realm) {
        return super.getWWWAuthenticateHeader(realm);
    }

    private String getKeyFilePath() {
        File confDir;
        J2EEServerInfo info = new J2EEServerInfo();
        String confPath = info.getExoConfigurationDirectory();
        File keyFile = null;
        if (confPath != null && (confDir = new File(confPath)) != null && confDir.exists() && confDir.isDirectory()) {
            keyFile = new File(confDir, "gadgets/key.txt");
        }
        if (keyFile == null) {
            keyFile = new File("key.txt");
        }
        return keyFile.getAbsolutePath();
    }
}

