/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.util.IdGenerator;

public class Attachment {
    private String id = "Attachment" + IdGenerator.generate();
    private String name;
    private String mimeType;
    private long size;
    private byte[] imageBytes;
    private Calendar lastModified;
    private String workspace;
    private String resourceId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType_) {
        this.mimeType = mimeType_;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size_) {
        this.size = size_;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public String getDataPath() throws Exception {
        Node attachmentData;
        try {
            attachmentData = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return attachmentData.getPath();
    }

    private Session getSesison() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getCurrentRepository().getSystemSession(this.workspace);
    }

    public void setInputStream(InputStream input) throws Exception {
        if (input != null) {
            this.imageBytes = new byte[input.available()];
            input.read(this.imageBytes);
        } else {
            this.imageBytes = null;
        }
    }

    public InputStream getInputStream() throws Exception {
        Node attachment;
        if (this.imageBytes != null) {
            return new ByteArrayInputStream(this.imageBytes);
        }
        try {
            attachment = (Node)this.getSesison().getItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException ex) {
            return null;
        }
        return attachment.getNode("jcr:content").getProperty("jcr:data").getStream();
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

