/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicationUtil {
    public static final String HISTORY_SEPARATOR = "; ";
    public static final String APPLICATION_SEPARATOR = "@";
    public static final String URI_SEPARATOR = "/";
    private static Application<Portlet> application = null;

    public static List<PageNode> findPageNodeByPageId(PageNavigation nav, String pageId) throws Exception {
        ArrayList<PageNode> list = new ArrayList<PageNode>();
        if (nav.getOwnerType().equals("portal")) {
            for (PageNode node : nav.getNodes()) {
                PublicationUtil.findPageNodeByPageId(node, pageId, list);
            }
        }
        return list;
    }

    public static void findPageNodeByPageId(PageNode node, String pageId, List<PageNode> allPageNode) throws Exception {
        List children;
        if (pageId.equals(node.getPageReference())) {
            allPageNode.add(node.clone());
        }
        if ((children = node.getChildren()) == null) {
            return;
        }
        for (PageNode child : children) {
            PublicationUtil.findPageNodeByPageId(child, pageId, allPageNode);
        }
    }

    public static List<String> findAppInstancesByName(Page page, String applicationName) {
        ArrayList<String> results = new ArrayList<String>();
        PublicationUtil.findAppInstancesByContainerAndName((Container)page, applicationName, results);
        return results;
    }

    private static void findAppInstancesByContainerAndName(Container container, String applicationName, List<String> results) {
    }

    public static Application<Portlet> findAppInstancesById(Container container, String applicationId) {
        return application;
    }

    private static void removedAppInstancesInContainerByNames(Container container, List<String> removingApplicationIds) {
        ArrayList<Container> childrenTmp = new ArrayList<Container>();
        ArrayList chidren = null;
        if (chidren == null) {
            return;
        }
        for (Object object : chidren) {
            if (object instanceof Application || !(object instanceof Container)) continue;
            Container child = (Container)Container.class.cast(object);
            PublicationUtil.removedAppInstancesInContainerByNames(child, removingApplicationIds);
            childrenTmp.add(child);
        }
    }

    public static List<String> getValuesAsString(Node node, String propName) throws Exception {
        if (!node.hasProperty(propName)) {
            return new ArrayList<String>();
        }
        ArrayList<String> results = new ArrayList<String>();
        try {
            for (Value value : node.getProperty(propName).getValues()) {
                results.add(value.getString());
            }
        }
        catch (ValueFormatException ex) {
            results.add(node.getProperty(propName).getValue().getString());
        }
        return results;
    }

    public static Value[] toValues(ValueFactory factory, List<String> values) {
        ArrayList<Value> list = new ArrayList<Value>();
        for (String value : values) {
            list.add(factory.createValue(value));
        }
        return list.toArray(new Value[list.size()]);
    }

    public static Node getNodeByApplicationId(String applicationId) throws Exception {
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        PortletPreferences portletPreferences = dataStorage.getPortletPreferences(applicationId);
        if (portletPreferences == null) {
            return null;
        }
        String repositoryName = null;
        String workspaceName = null;
        String nodeIdentifier = null;
        for (Preference object : portletPreferences.getPreferences()) {
            Preference preference = object;
            if (preference.getName().equals("repository")) {
                repositoryName = ((String)preference.getValues().get(0)).toString();
                continue;
            }
            if (preference.getName().equals("workspace")) {
                workspaceName = ((String)preference.getValues().get(0)).toString();
                continue;
            }
            if (!preference.getName().equals("nodeIdentifier")) continue;
            nodeIdentifier = ((String)preference.getValues().get(0)).toString();
        }
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        if (repositoryName != null && workspaceName != null && nodeIdentifier != null) {
            Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
            Node content = null;
            try {
                content = session.getNodeByUUID(nodeIdentifier);
            }
            catch (ItemNotFoundException e) {
                try {
                    content = (Node)session.getItem(nodeIdentifier);
                }
                catch (RepositoryException re) {
                    // empty catch block
                }
            }
            return content;
        }
        return null;
    }

    public static void removeApplicationFromPage(Page page, List<String> removedApplicationIds) {
        PublicationUtil.removedAppInstancesInContainerByNames((Container)page, removedApplicationIds);
    }

    public static List<String> getListApplicationIdByPage(Page page, String portletName) {
        return PublicationUtil.findAppInstancesByName(page, portletName);
    }

    public static String setMixedNavigationUri(String portalName, String pageNodeUri) {
        return URI_SEPARATOR + portalName + URI_SEPARATOR + pageNodeUri;
    }

    public static String[] parseMixedNavigationUri(String mixedNavigationUri) {
        String[] mixedNavigationUris = new String[2];
        int first = 1;
        int second = mixedNavigationUri.indexOf(URI_SEPARATOR, first);
        mixedNavigationUris[0] = mixedNavigationUri.substring(first, second);
        mixedNavigationUris[1] = mixedNavigationUri.substring(second + URI_SEPARATOR.length(), mixedNavigationUri.length());
        return mixedNavigationUris;
    }

    public static String setMixedApplicationId(String pageId, String applicationId) {
        return pageId + APPLICATION_SEPARATOR + applicationId;
    }

    public static String[] parseMixedApplicationId(String mixedApplicationId) {
        return mixedApplicationId.split(APPLICATION_SEPARATOR);
    }

    public static boolean isNodeContentPublishedToPageNode(Node contentNode, String navNodeURI) throws Exception {
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        PageNavigation pageNavigation = dataStorage.getPageNavigation("portal", Util.getUIPortalApplication().getOwner());
        ArrayList<PageNode> lisPageNodes = PublicationUtil.getAllPageNodeFromPageNavigation(pageNavigation);
        PageNode pageNode = null;
        for (PageNode tempPageNode : lisPageNodes) {
            if (!tempPageNode.getUri().equals(navNodeURI.replace(URI_SEPARATOR + Util.getUIPortalApplication().getOwner() + URI_SEPARATOR, ""))) continue;
            pageNode = tempPageNode;
            break;
        }
        if (pageNode == null || pageNode.getPageReference() == null) {
            return false;
        }
        return PublicationUtil.getValuesAsString(contentNode, "publication:webPageIDs").contains(pageNode.getPageReference());
    }

    public static ArrayList<PageNode> getAllPageNodeFromPageNavigation(PageNavigation pageNavigation) {
        ArrayList<PageNode> pageNodeList = new ArrayList<PageNode>();
        if (pageNavigation == null || pageNavigation.getNodes() == null) {
            return null;
        }
        for (PageNode pageNode : pageNavigation.getNodes()) {
            pageNodeList.add(pageNode);
            pageNodeList.addAll(PublicationUtil.getChildrenPageNodes(pageNode));
        }
        return pageNodeList;
    }

    private static ArrayList<PageNode> getChildrenPageNodes(PageNode parentPageNode) {
        ArrayList<PageNode> pageNodeList = new ArrayList<PageNode>();
        if (parentPageNode == null || parentPageNode.getChildren() == null) {
            return pageNodeList;
        }
        for (PageNode pageNode : parentPageNode.getChildren()) {
            pageNodeList.add(pageNode);
            if (pageNode.getChildren() == null || pageNode.getChildren().size() <= 0) continue;
            pageNodeList.addAll(PublicationUtil.getChildrenPageNodes(pageNode));
        }
        return pageNodeList;
    }
}

