/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NodeLocation {
    private static Log log = ExoLogger.getLogger((String)"wcm:NodeLocation");
    private String repository;
    private String workspace;
    private String path;

    public NodeLocation() {
    }

    public NodeLocation(String repository, String workspace, String path) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Deprecated
    public static final NodeLocation parse(String exp) {
        String[] temp = NodeLocation.split(exp, ":");
        if (temp.length == 3 && temp[2].indexOf("/") == 0) {
            return new NodeLocation(temp[0], temp[1], temp[2]);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    @Deprecated
    public static final NodeLocation make(Node node) {
        try {
            Session session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            return new NodeLocation(repository, workspace, path);
        }
        catch (RepositoryException e) {
            log.error((Object)"make() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static final NodeLocation getNodeLocationByExpression(String exp) {
        String[] temp = NodeLocation.split(exp, ":");
        if (temp.length >= 3 && temp[2].indexOf("/") == 0) {
            String repository = temp[0];
            String workspace = temp[1];
            String nodepath = exp.substring(repository.length() + workspace.length() + 2);
            return new NodeLocation(repository, workspace, nodepath);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    public static final NodeLocation getNodeLocationByNode(Node node) {
        Session session = null;
        try {
            session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            return new NodeLocation(repository, workspace, path);
        }
        catch (RepositoryException e) {
            log.error((Object)"getNodeLocationByNode() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static final Node getNodeByLocation(NodeLocation nodeLocation) {
        Session session = null;
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository(nodeLocation.getRepository());
            session = WCMCoreUtils.getSystemSessionProvider().getSession(nodeLocation.getWorkspace(), repository);
            Node node = (Node)session.getItem(nodeLocation.getPath());
            return node;
        }
        catch (PathNotFoundException pne) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"getNodeByNodeLocation() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static final Node getNodeByExpression(String expression) {
        return NodeLocation.getNodeByLocation(NodeLocation.parse(expression));
    }

    public static final String getExpressionByNode(Node node) {
        NodeLocation location = NodeLocation.getNodeLocationByNode(node);
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public static final String getExpressionByNodeLocation(NodeLocation location) {
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public String toString() {
        return NodeLocation.mergeString(this.repository, this.workspace, this.path);
    }

    private static String mergeString(String repository, String workspace, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repository);
        buffer.append(":");
        buffer.append(workspace);
        buffer.append(":");
        buffer.append(path);
        return buffer.toString();
    }

    private static final String[] split(String s, String ch) {
        int maxLength = 3;
        String[] ss = new String[maxLength];
        int prev = 0;
        int i = 0;
        while (true) {
            int next;
            if ((next = s.indexOf(ch, prev)) == -1 || i == maxLength - 1) break;
            ss[i++] = s.substring(prev, next);
            prev = next + 1;
        }
        ss[i] = s.substring(prev);
        return ss;
    }
}

