/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.listener;

import javax.jcr.Node;
import org.exoplatform.portal.config.DataStorageImpl;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.RemovePortalArtifactsService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLivePortalEventListener
extends Listener<DataStorageImpl, PortalConfig> {
    private Log log = ExoLogger.getLogger(RemoveLivePortalEventListener.class);

    public void onEvent(Event<DataStorageImpl, PortalConfig> event) throws Exception {
        PortalConfig portalConfig = (PortalConfig)event.getData();
        if (!"portal".equals(portalConfig.getType())) {
            return;
        }
        String portalName = portalConfig.getName();
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node portal = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        ManageDriveService manageDriveService = WCMCoreUtils.getService(ManageDriveService.class);
        String repository = NodeLocation.make(portal).getRepository();
        try {
            manageDriveService.removeDrive(portalName, repository);
            this.log.info((Object)("Removed drive for portal: " + portalName));
        }
        catch (Exception e) {
            this.log.error((Object)("Error when remove drive for portal: " + portalName), (Throwable)e);
        }
        RemovePortalArtifactsService removePortalArtifactsService = WCMCoreUtils.getService(RemovePortalArtifactsService.class);
        removePortalArtifactsService.invalidateArtifactsFromPortal(sessionProvider, portalName);
        try {
            livePortalManagerService.removeLivePortal(sessionProvider, portalConfig);
            this.log.info((Object)("Removed resource storage for portal: " + portalName));
        }
        catch (Exception e) {
            this.log.error((Object)("Error when remove resource storage: " + portalName), (Throwable)e);
        }
    }
}

