/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.notify;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ks.common.Common;
import org.exoplatform.ks.common.NotifyInfo;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotifyJob
implements Job {
    private NotifyInfo notify_;
    private static Log log_ = ExoLogger.getLogger(NotifyJob.class);

    public void setMessageInfo(NotifyInfo notifyInfo) {
        this.notify_ = notifyInfo;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ExoContainer exoContainer = Utils.getExoContainer(context);
            MailService mailService = (MailService)exoContainer.getComponentInstanceOfType(MailService.class);
            String name = context.getJobDetail().getName();
            Common common = new Common();
            NotifyInfo messageInfo = common.getMessageInfo(name);
            List<String> emailAddresses = messageInfo.getEmailAddresses();
            Message message = messageInfo.getMessage();
            JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-faq", context.getJobDetail().getJobClass());
            if (message != null && emailAddresses != null && emailAddresses.size() > 0) {
                ArrayList<String> sentMessages = new ArrayList<String>();
                int countEmail = 0;
                for (String address : emailAddresses) {
                    if (sentMessages.contains(address)) continue;
                    message.setTo(address);
                    mailService.sendMessage(message);
                    sentMessages.add(address);
                    ++countEmail;
                }
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)("\n\nEmail notifications for Thread Save Question have been sent to " + countEmail + " addresses"));
                }
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            log_.error((Object)"Failed to execute email notification job", (Throwable)e);
        }
    }
}

