/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wci.endpoint;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.servlet.URLFormat;
import org.gatein.common.text.CharBuffer;
import org.gatein.common.text.CharEncoder;
import org.gatein.common.text.FastURLEncoder;
import org.gatein.wci.endpoint.EndPointRequest;
import org.gatein.wci.impl.AbstractWebResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndPointResponse
extends AbstractWebResponse {
    private static final FastURLEncoder urlEncoder = FastURLEncoder.getUTF8Instance();
    private static final URLFormat nullFormat = URLFormat.create(null, null, null, null, null);
    private String requestRelativePrefix;
    private String requestPrefix;
    private final EndPointRequest req;

    public EndPointResponse(EndPointRequest req, HttpServletResponse resp) {
        super(resp);
        this.req = req;
    }

    private String getRequestRelativePrefix() {
        if (this.requestRelativePrefix == null) {
            StringBuilder requestRelativePrefix = new StringBuilder();
            requestRelativePrefix.append(this.req.getScheme()).append("://").append(this.req.getServerName());
            if (this.req.isSecure()) {
                if (this.req.getServerPort() != 443) {
                    requestRelativePrefix.append(":").append(Integer.toString(this.req.getServerPort()));
                }
            } else if (this.req.getServerPort() != 80) {
                requestRelativePrefix.append(":").append(Integer.toString(this.req.getServerPort()));
            }
            requestRelativePrefix.append(this.req.getContextPath());
            if (this.req.getMappingType() != 0) {
                requestRelativePrefix.append(this.req.getServletPath());
            }
            this.requestRelativePrefix = requestRelativePrefix.toString();
        }
        return this.requestRelativePrefix;
    }

    private String getRequestPrefix() {
        if (this.requestPrefix == null) {
            this.requestPrefix = this.req.getMappingType() != 0 ? this.req.getContextPath() : this.req.getContextPath() + this.req.getServletPath();
        }
        return this.requestPrefix;
    }

    @Override
    public String renderURL(String path, Map<String, String[]> parameters, URLFormat wantedURLFormat) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("No null path accepted");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path value " + path + " should start with a trailing '/'");
        }
        if (wantedURLFormat == null) {
            wantedURLFormat = nullFormat;
        }
        Buffer buffer = new Buffer(wantedURLFormat);
        return buffer.toString(path, parameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Buffer
    extends CharBuffer {
        private final URLFormat format;
        private final int prefixLength;
        private final String parameterSeparator;

        public Buffer(URLFormat format) {
            if (Boolean.FALSE.equals(format.getRelative())) {
                this.append(EndPointResponse.this.getRequestPrefix());
            } else {
                this.append(EndPointResponse.this.getRequestRelativePrefix());
            }
            this.prefixLength = this.length;
            this.format = format;
            this.parameterSeparator = Boolean.TRUE.equals(format.getEscapeXML()) ? "&amp;" : "&";
        }

        public String toString(String path, Map<String, String[]> parameters) {
            this.length = this.prefixLength;
            this.append(path);
            boolean first = true;
            if (parameters != null) {
                for (Map.Entry<String, String[]> parameter : parameters.entrySet()) {
                    String[] values;
                    String name = parameter.getKey();
                    if (name == null) {
                        throw new IllegalArgumentException("Null key in the parameter map are not allowed");
                    }
                    for (String value : values = parameter.getValue()) {
                        if (value == null) {
                            throw new IllegalArgumentException("Null value for the key " + name + " in the parameter map are not allowed");
                        }
                        this.append(first ? "?" : this.parameterSeparator);
                        this.append(name, (CharEncoder)urlEncoder);
                        this.append('=');
                        this.append(value, (CharEncoder)urlEncoder);
                        first = false;
                    }
                }
            }
            String s = this.asString();
            if (!Boolean.FALSE.equals(this.format.getServletEncoded())) {
                s = EndPointResponse.this.encodeURL(s);
            }
            return s;
        }
    }
}

