/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.LinearGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType2Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType2Pattern.class.toString());
    protected Function function;
    protected Vector<Float> domain;
    protected Vector coords;
    protected Vector<Boolean> extend;
    private LinearGradientPaint linearGradientPaint;

    public ShadingType2Pattern(Library library, Hashtable entries) {
        super(library, entries);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, "Shading");
        }
        this.shadingType = this.library.getInt(this.shading, "ShadingType");
        this.bBox = this.library.getRectangle(this.shading, "BBox");
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, "ColorSpace"));
        if (this.library.getObject(this.shading, "Background") != null && this.library.getObject(this.shading, "Background") instanceof Vector) {
            this.background = (Vector)this.library.getObject(this.shading, "Background");
        }
        this.antiAlias = this.library.getBoolean(this.shading, "AntiAlias");
        if (this.library.getObject(this.shading, "Domain") instanceof Vector) {
            this.domain = (Vector)this.library.getObject(this.shading, "Domain");
        } else {
            this.domain = new Vector(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        if (this.library.getObject(this.shading, "Coords") instanceof Vector) {
            this.coords = (Vector)this.library.getObject(this.shading, "Coords");
        }
        if (this.library.getObject(this.shading, "Extend") instanceof Vector) {
            this.extend = (Vector)this.library.getObject(this.shading, "Extend");
        } else {
            this.extend = new Vector(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        Object tmp = this.library.getObject(this.shading, "Function");
        if (tmp != null) {
            this.function = Function.getFunction(this.library, tmp);
        }
        float t0 = ((Number)this.domain.get(0)).floatValue();
        float t1 = ((Number)this.domain.get(1)).floatValue();
        Point2D.Float point1 = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        Point2D.Float point2 = new Point2D.Float(((Number)this.coords.get(2)).floatValue(), ((Number)this.coords.get(3)).floatValue());
        Point2D.Float point3 = new Point2D.Float((point2.x + point1.x) / 2.0f, (point2.y + point1.y) / 2.0f);
        Point2D.Float point4 = new Point2D.Float((point3.x + point1.x) / 2.0f, (point3.y + point1.y) / 2.0f);
        Point2D.Float point5 = new Point2D.Float((point2.x + point3.x) / 2.0f, (point2.y + point3.y) / 2.0f);
        Color color1 = this.calculateColour(this.colorSpace, point1, point1, point2, t0, t1);
        Color color2 = this.calculateColour(this.colorSpace, point2, point1, point2, t0, t1);
        Color color3 = this.calculateColour(this.colorSpace, point3, point1, point2, t0, t1);
        if (color1 == null || color2 == null || color3 == null) {
            return;
        }
        float[] dist = new float[]{t0, t1 / 2.0f, t1};
        Color[] colors = new Color[]{color1, color3, color2};
        this.linearGradientPaint = new LinearGradientPaint(point1, point2, dist, colors, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    private Color calculateColour(PColorSpace colorSpace, Point2D.Float xy, Point2D.Float point1, Point2D.Float point2, float t0, float t1) {
        float xPrime = this.linearMapping(xy, point1, point2);
        float t = this.parametrixValue(xPrime, t0, t1, this.extend);
        float[] input = new float[]{t};
        if (this.function != null) {
            float[] output = this.function.calculate(input);
            if (output != null) {
                if (!(colorSpace instanceof DeviceN)) {
                    output = PColorSpace.reverse(output);
                }
                return colorSpace.getColor(output);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 2 Pattern.");
        return null;
    }

    private float linearMapping(Point2D.Float xy, Point2D.Float point1, Point2D.Float point2) {
        float x = xy.x;
        float y = xy.y;
        float x0 = point1.x;
        float y0 = point1.y;
        float x1 = point2.x;
        float y1 = point2.y;
        float top = (x1 - x0) * (x - x0) + (y1 - y0) * (y - y0);
        float bottom = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
        return top / bottom;
    }

    private float parametrixValue(float linearMapping, float t0, float t1, Vector extended) {
        if (linearMapping < 0.0f && ((Boolean)extended.get(0)).booleanValue()) {
            return t0;
        }
        if (linearMapping > 1.0f && ((Boolean)extended.get(1)).booleanValue()) {
            return t1;
        }
        return t0 + (t1 - t0) * linearMapping;
    }

    public Paint getPaint() {
        this.init();
        return this.linearGradientPaint;
    }

    public String toString() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

