/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bench;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.exoplatform.forum.bench.ForumDataProvider;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpBBForumDataProvider
implements ForumDataProvider {
    DataSource ds;

    PhpBBForumDataProvider() throws Exception {
        InitialContext ctx = new InitialContext();
        this.ds = (DataSource)ctx.lookup("phpBBDS");
    }

    @Override
    public List<Category> findCategories() {
        SimpleMapper<Category> mapper = new SimpleMapper<Category>(){

            @Override
            public Category mapResult(ResultSet rs) throws SQLException {
                Category cat = PhpBBForumDataProvider.this.newCategory(rs.getString("cat_title"), rs.getLong("cat_order"));
                return cat;
            }
        };
        SimpleJDBCTemplate<Category> template = new SimpleJDBCTemplate<Category>(mapper);
        List<Category> result = template.execute("SELECT * FROM phpbb_categories");
        return result;
    }

    protected Category newCategory(String name, long order) {
        Category category = new Category();
        category.setCategoryName(name);
        category.setCategoryOrder(order);
        category.setCreatedDate(new Date());
        category.setDescription("");
        category.setModifiedBy("root");
        category.setModifiedDate(new Date());
        category.setOwner("root");
        return category;
    }

    @Override
    public List<Forum> findForumsByCategory(String categoryId) {
        SimpleMapper<Forum> mapper = new SimpleMapper<Forum>(){

            @Override
            public Forum mapResult(ResultSet rs) throws SQLException {
                Forum forum = PhpBBForumDataProvider.this.newForum(rs.getString("forum_name"), rs.getString("forum_desc"), rs.getInt("forum_order"));
                return forum;
            }
        };
        SimpleJDBCTemplate<Forum> template = new SimpleJDBCTemplate<Forum>(mapper);
        List<Forum> result = template.execute("SELECT * FROM phpbb_forums WHERE cat_id=" + categoryId);
        return result;
    }

    protected Forum newForum(String name, String desc, int order) {
        Forum forum = new Forum();
        forum.setCreatedDate(new Date());
        forum.setDescription(desc);
        forum.setForumName(name);
        forum.setForumOrder(order);
        forum.setOwner("root");
        return forum;
    }

    @Override
    public List<Post> fingPostsByTopic(Topic topic) {
        String forumId = topic.getForumId();
        SimpleMapper<Post> mapper = new SimpleMapper<Post>(){

            @Override
            public Post mapResult(ResultSet rs) throws SQLException {
                Post post = PhpBBForumDataProvider.this.newPost(rs.getString("post_subject"), rs.getString("post_text"));
                return post;
            }
        };
        SimpleJDBCTemplate<Post> template = new SimpleJDBCTemplate<Post>(mapper);
        List<Post> result = template.execute("SELECT t.post_subject, t.post_text  FROM phpbb_posts p, phpbb_posts_text t WHERE p.post_id=t.post_id AND p.forum_id=" + forumId);
        return result;
    }

    protected Post newPost(String subject, String text) {
        Post post = new Post();
        post.setName(subject);
        post.setMessage(text);
        post.setOwner("root");
        post.setIcon("Shield");
        return post;
    }

    @Override
    public List<Topic> findTopicsByForum(Forum forum) {
        String forumId = forum.getId();
        SimpleMapper<Topic> mapper = new SimpleMapper<Topic>(){

            @Override
            public Topic mapResult(ResultSet rs) throws SQLException {
                Topic topic = PhpBBForumDataProvider.this.newTopic(rs.getString("post_subject"), rs.getString("post_text"));
                return topic;
            }
        };
        SimpleJDBCTemplate<Topic> template = new SimpleJDBCTemplate<Topic>(mapper);
        List<Topic> result = template.execute("SELECT t.post_subject, t.post_text FROM phpbb_topics topics, phpbb_posts p, phpbb_posts_text t WHERE topics.topic_first_post_id = p.post_id AND p.post_id=t.post_id  AND forum_id=" + forumId);
        return result;
    }

    protected Topic newTopic(String name, String text) {
        Topic topic = new Topic();
        topic.setCreatedDate(new Date());
        topic.setDescription(text);
        topic.setOwner("root");
        topic.setTopicName(name);
        topic.setIcon("Shield");
        return topic;
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleJDBCTemplate<T> {
        SimpleMapper<T> mapper;

        public SimpleJDBCTemplate(SimpleMapper<T> mapper) {
            this.mapper = mapper;
        }

        public List<T> execute(String query) {
            ArrayList<T> result = new ArrayList<T>();
            Connection conn = null;
            try {
                conn = PhpBBForumDataProvider.this.ds.getConnection();
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    T obj = this.mapper.mapResult(rs);
                    result.add(obj);
                }
                ArrayList<T> arrayList = result;
                return arrayList;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SimpleMapper<T> {
        public T mapResult(ResultSet var1) throws SQLException;
    }
}

