/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.web.servlet;

import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.web.WebContext;
import org.apache.commons.chain.web.servlet.ServletApplicationScopeMap;
import org.apache.commons.chain.web.servlet.ServletHeaderMap;
import org.apache.commons.chain.web.servlet.ServletHeaderValuesMap;
import org.apache.commons.chain.web.servlet.ServletInitParamMap;
import org.apache.commons.chain.web.servlet.ServletParamMap;
import org.apache.commons.chain.web.servlet.ServletParamValuesMap;
import org.apache.commons.chain.web.servlet.ServletRequestScopeMap;
import org.apache.commons.chain.web.servlet.ServletSessionScopeMap;

public class ServletWebContext
extends WebContext {
    private Map applicationScope = null;
    protected ServletContext context = null;
    private Map header = null;
    private Map headerValues = null;
    private Map initParam = null;
    private Map param = null;
    private Map paramValues = null;
    protected HttpServletRequest request = null;
    private Map requestScope = null;
    protected HttpServletResponse response = null;
    private Map sessionScope = null;

    public ServletWebContext() {
    }

    public ServletWebContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.initialize(context, request, response);
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void initialize(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public void release() {
        this.applicationScope = null;
        this.header = null;
        this.headerValues = null;
        this.initParam = null;
        this.param = null;
        this.paramValues = null;
        this.requestScope = null;
        this.sessionScope = null;
        this.context = null;
        this.request = null;
        this.response = null;
    }

    public Map getApplicationScope() {
        if (this.applicationScope == null && this.context != null) {
            this.applicationScope = new ServletApplicationScopeMap(this.context);
        }
        return this.applicationScope;
    }

    public Map getHeader() {
        if (this.header == null && this.request != null) {
            this.header = new ServletHeaderMap(this.request);
        }
        return this.header;
    }

    public Map getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = new ServletHeaderValuesMap(this.request);
        }
        return this.headerValues;
    }

    public Map getInitParam() {
        if (this.initParam == null && this.context != null) {
            this.initParam = new ServletInitParamMap(this.context);
        }
        return this.initParam;
    }

    public Map getParam() {
        if (this.param == null && this.request != null) {
            this.param = new ServletParamMap(this.request);
        }
        return this.param;
    }

    public Map getParamValues() {
        if (this.paramValues == null && this.request != null) {
            this.paramValues = new ServletParamValuesMap(this.request);
        }
        return this.paramValues;
    }

    public Map getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new ServletRequestScopeMap(this.request);
        }
        return this.requestScope;
    }

    public Map getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new ServletSessionScopeMap(this.request.getSession());
        }
        return this.sessionScope;
    }
}

