/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeFactory;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private Object nextVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Serializable id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, id, instance, persister);
        this.state = state;
        this.previousState = previousState;
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.rowId = rowId;
    }

    public void execute() throws HibernateException {
        EntityEntry entry;
        CacheKey ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preUpdate();
        SessionFactoryImplementor factory = this.getSession().getFactory();
        Object previousVersion = this.previousVersion;
        if (persister.isVersionPropertyGenerated()) {
            previousVersion = persister.getVersion(instance, session.getEntityMode());
        }
        if (persister.hasCache()) {
            ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            this.lock = persister.getCacheAccessStrategy().lockItem(ck, previousVersion);
        } else {
            ck = null;
        }
        if (!veto) {
            persister.update(id, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, previousVersion, instance, this.rowId, session);
        }
        if ((entry = this.getSession().getPersistenceContext().getEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            TypeFactory.deepCopy(this.state, persister.getPropertyTypes(), persister.getPropertyCheckability(), this.state, session);
            if (persister.hasUpdateGeneratedProperties()) {
                persister.processUpdateGeneratedProperties(id, instance, this.state, session);
                if (persister.isVersionPropertyGenerated()) {
                    this.nextVersion = Versioning.getVersion(this.state, persister);
                }
            }
            entry.postUpdate(instance, this.state, this.nextVersion);
        }
        if (persister.hasCache()) {
            if (persister.isCacheInvalidationRequired() || entry.getStatus() != Status.MANAGED) {
                persister.getCacheAccessStrategy().remove(ck);
            } else {
                CacheEntry ce = new CacheEntry(this.state, persister, persister.hasUninitializedLazyProperties(instance, session.getEntityMode()), this.nextVersion, this.getSession(), instance);
                this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
                boolean put = persister.getCacheAccessStrategy().update(ck, this.cacheEntry, this.nextVersion, previousVersion);
                if (put && factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        this.postUpdate();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().updateEntity(this.getPersister().getEntityName());
        }
    }

    private void postUpdate() {
        PostUpdateEventListener[] postListeners = this.getSession().getListeners().getPostUpdateEventListeners();
        if (postListeners.length > 0) {
            PostUpdateEvent postEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostUpdate(postEvent);
            }
        }
    }

    private void postCommitUpdate() {
        PostUpdateEventListener[] postListeners = this.getSession().getListeners().getPostCommitUpdateEventListeners();
        if (postListeners.length > 0) {
            PostUpdateEvent postEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostUpdate(postEvent);
            }
        }
    }

    private boolean preUpdate() {
        PreUpdateEventListener[] preListeners = this.getSession().getListeners().getPreUpdateEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreUpdateEvent preEvent = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreUpdate(preEvent) || veto;
            }
        }
        return veto;
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        EntityPersister persister = this.getPersister();
        if (persister.hasCache()) {
            CacheKey ck = new CacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            if (success && this.cacheEntry != null) {
                boolean put = persister.getCacheAccessStrategy().afterUpdate(ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
                if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
                }
            } else {
                persister.getCacheAccessStrategy().unlockItem(ck, this.lock);
            }
        }
        this.postCommitUpdate();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitUpdateEventListeners().length > 0;
    }
}

