/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.AnnotatedProperty;
import org.chromattic.metamodel.bean.ValueInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.introspection.AnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyInfo<V extends ValueInfo> {
    private final String name;
    private final MethodInfo getter;
    private final MethodInfo setter;
    private final V value;

    public PropertyInfo(String name, V value, MethodInfo getter, MethodInfo setter) {
        this.name = name;
        this.value = value;
        this.getter = getter;
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    public V getValue() {
        return this.value;
    }

    public AccessMode getAccessMode() {
        if (this.getter == null) {
            if (this.setter == null) {
                throw new AssertionError((Object)"wtf");
            }
            return AccessMode.WRITE_ONLY;
        }
        if (this.setter == null) {
            return AccessMode.READ_ONLY;
        }
        return AccessMode.READ_WRITE;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public Collection<AnnotatedProperty<?>> getAnnotateds(Class<? extends Annotation> ... annotationClasses) {
        ArrayList props = new ArrayList();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            AnnotatedProperty<? extends Annotation> annotation = this.getAnnotated(annotationClass);
            if (annotation == null) continue;
            props.add(annotation);
        }
        return props;
    }

    public <A extends Annotation> AnnotatedProperty<A> getAnnotated(Class<A> annotationClass) {
        Annotation setterAnnotation;
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        Annotation annotation = null;
        ClassTypeInfo owner = null;
        if (this.getter != null && (annotation = new AnnotationIntrospector(annotationClass).resolve(this.getter)) != null) {
            owner = this.getter.getOwner();
        }
        if (this.setter != null && (setterAnnotation = new AnnotationIntrospector(annotationClass).resolve(this.setter)) != null) {
            if (annotation != null) {
                throw new IllegalStateException("The same annotation " + annotation + " is present on a getter " + this.getter + " and setter" + this.setter);
            }
            annotation = setterAnnotation;
            owner = this.setter.getOwner();
        }
        if (annotation != null) {
            return new AnnotatedProperty<Annotation>(annotation, owner, this);
        }
        return null;
    }

    public String toString() {
        return "Property[name=" + this.name + "]";
    }
}

