/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.util.List;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UITree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/core/UIFilterableTree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})})
@Serialized
public class UIFilterableTree
extends UITree {
    private TreeNodeFilter nodeFilter;

    public boolean displayThisNode(Object nodeObject, WebuiRequestContext context) {
        if (this.nodeFilter == null) {
            return true;
        }
        return !this.nodeFilter.filterThisNode(nodeObject, context);
    }

    public int getRightMostDisplayedNodeIndex(List<Object> sibblings, WebuiRequestContext context) {
        if (sibblings == null) {
            return -1;
        }
        int numberOfSibblings = sibblings.size();
        if (this.nodeFilter == null) {
            return numberOfSibblings - 1;
        }
        for (int i = numberOfSibblings - 1; i >= 0; --i) {
            if (this.nodeFilter.filterThisNode(sibblings.get(i), context)) continue;
            return i;
        }
        return -1;
    }

    public int getLeftMostDisplayedNodeIndex(List<Object> sibblings, WebuiRequestContext context) {
        if (sibblings == null) {
            return -1;
        }
        int numberOfSibblings = sibblings.size();
        if (this.nodeFilter == null) {
            return 0;
        }
        for (int i = 0; i < numberOfSibblings; ++i) {
            if (this.nodeFilter.filterThisNode(sibblings.get(i), context)) continue;
            return i;
        }
        return numberOfSibblings;
    }

    public void setTreeNodeFilter(TreeNodeFilter _nodeFilter) {
        this.nodeFilter = _nodeFilter;
    }

    public static interface TreeNodeFilter {
        public boolean filterThisNode(Object var1, WebuiRequestContext var2);
    }
}

