/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.document.diff.Chunk;
import org.exoplatform.services.document.impl.diff.ToStringImpl;

public class ChunkImpl
extends ToStringImpl
implements Chunk {
    protected int anchor;
    protected int count;
    protected List chunk;

    public ChunkImpl(int pos, int count) {
        this.anchor = pos;
        this.count = count >= 0 ? count : 0;
    }

    public ChunkImpl(Object[] iseq, int pos, int count) {
        this(pos, count);
        this.chunk = this.slice(iseq, pos, count);
    }

    public ChunkImpl(Object[] iseq, int pos, int count, int offset) {
        this(offset, count);
        this.chunk = this.slice(iseq, pos, count);
    }

    public ChunkImpl(List iseq, int pos, int count) {
        this(pos, count);
        this.chunk = this.slice(iseq, pos, count);
    }

    public ChunkImpl(List iseq, int pos, int count, int offset) {
        this(offset, count);
        this.chunk = this.slice(iseq, pos, count);
    }

    public int anchor() {
        return this.anchor;
    }

    public int size() {
        return this.count;
    }

    public int first() {
        return this.anchor();
    }

    public int last() {
        return this.anchor() + this.size() - 1;
    }

    public int rcsfrom() {
        return this.anchor + 1;
    }

    public int rcsto() {
        return this.anchor + this.count;
    }

    public List chunk() {
        return this.chunk;
    }

    public boolean verify(List target) {
        if (this.chunk == null) {
            return true;
        }
        if (this.last() > target.size()) {
            return false;
        }
        for (int i = 0; i < this.count; ++i) {
            if (target.get(this.anchor + i).equals(this.chunk.get(i))) continue;
            return false;
        }
        return true;
    }

    public void applyDelete(List target) {
        for (int i = this.last(); i >= this.first(); --i) {
            target.remove(i);
        }
    }

    public void applyAdd(int start, List target) {
        Iterator i = this.chunk.iterator();
        while (i.hasNext()) {
            target.add(start++, i.next());
        }
    }

    public void toString(StringBuffer s) {
        this.toString(s, "", "");
    }

    public StringBuffer toString(StringBuffer s, String prefix, String postfix) {
        if (this.chunk != null) {
            Iterator i = this.chunk.iterator();
            while (i.hasNext()) {
                s.append(prefix);
                s.append(i.next());
                s.append(postfix);
            }
        }
        return s;
    }

    public List slice(List seq, int pos, int count) {
        if (count <= 0) {
            return new ArrayList(seq.subList(pos, pos));
        }
        return new ArrayList(seq.subList(pos, pos + count));
    }

    public List slice(Object[] seq, int pos, int count) {
        return this.slice(Arrays.asList(seq), pos, count);
    }

    public String rangeString() {
        StringBuffer result = new StringBuffer();
        this.rangeString(result);
        return result.toString();
    }

    public void rangeString(StringBuffer s) {
        this.rangeString(s, ",");
    }

    public void rangeString(StringBuffer s, String separ) {
        if (this.size() <= 1) {
            s.append(Integer.toString(this.rcsfrom()));
        } else {
            s.append(Integer.toString(this.rcsfrom()));
            s.append(separ);
            s.append(Integer.toString(this.rcsto()));
        }
    }
}

