/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={CustomActionListener.class})})
public class CustomManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger(CustomManageComponent.class);

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void customManage(Event<? extends UIComponent> event, UIJCRExplorer uiExplorer, UIApplication uiApp) throws Exception {
        UIWorkingArea uicomp = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        String actionName = event.getRequestContext().getRequestParameter("actionName");
        String repository = uiExplorer.getRepositoryName();
        String wsName = event.getRequestContext().getRequestParameter("workspaceName");
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        ActionServiceContainer actionService = (ActionServiceContainer)uicomp.getApplicationComponent(ActionServiceContainer.class);
        try {
            Node node = uiExplorer.getNodeByPath(nodePath, session);
            String userId = event.getRequestContext().getRemoteUser();
            actionService.executeAction(userId, node, actionName, repository);
            Object[] arg = new Object[]{actionName};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.execute-successfully", arg));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
        catch (Exception e) {
            LOG.error((Object)"an unexpected error occurs while calling custom action on the node", (Throwable)e);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CustomActionListener
    extends UIWorkingAreaActionListener<CustomManageComponent> {
        public void processEvent(Event<CustomManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((CustomManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)((CustomManageComponent)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
            CustomManageComponent.customManage(event, uiExplorer, uiApp);
        }
    }
}

