/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.PING;
import org.jgroups.protocols.TUNNEL;
import org.jgroups.stack.GossipRouter;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class DisconnectTest
extends TestCase {
    private JChannel channel;

    public DisconnectTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private static JChannel createChannel() throws ChannelException {
        return new JChannel("tunnel.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullLocalAddress_TUNNEL() throws Exception {
        GossipRouter router = null;
        try {
            router = new GossipRouter();
            router.start();
            this.channel = DisconnectTest.createChannel();
            this.channel.connect("testgroup");
            DisconnectTest.assertNotNull((Object)this.channel.getLocalAddress());
            this.channel.disconnect();
            DisconnectTest.assertNull((Object)this.channel.getLocalAddress());
        }
        finally {
            if (router != null) {
                router.stop();
            }
        }
    }

    public void testDisconnectConnectOne_Default() throws Exception {
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup2");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)1, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
    }

    public void testDisconnectConnectTwo_Default() throws Exception {
        JChannel coordinator = new JChannel();
        coordinator.connect("testgroup");
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        View view = this.channel.getView();
        DisconnectTest.assertEquals((int)2, (int)view.size());
        DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
        coordinator.close();
    }

    public void testDisconnectConnectSendTwo_Default() throws Exception {
        Promise msgPromise = new Promise();
        JChannel coordinator = new JChannel();
        coordinator.setReceiver(new PromisedMessageListener(msgPromise));
        coordinator.connect("testgroup");
        this.channel = new JChannel();
        this.channel.connect("testgroup1");
        this.channel.disconnect();
        this.channel.connect("testgroup");
        this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
        Message msg = (Message)msgPromise.getResult(20000L);
        DisconnectTest.assertNotNull((Object)msg);
        DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
        coordinator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisconnectConnectOne_TUNNEL() throws Exception {
        GossipRouter router = null;
        try {
            router = new GossipRouter();
            router.start();
            this.channel = DisconnectTest.createChannel();
            this.channel.connect("testgroup1");
            this.channel.disconnect();
            this.channel.connect("testgroup2");
            View view = this.channel.getView();
            DisconnectTest.assertEquals((int)1, (int)view.size());
            DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
        }
        finally {
            if (router != null) {
                router.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectTwo_TUNNEL() throws Exception {
        GossipRouter router = null;
        try {
            router = new GossipRouter();
            router.start();
            JChannel coordinator = DisconnectTest.createChannel();
            DisconnectTest.setProps(coordinator);
            coordinator.connect("testConnectTwo_TUNNEL");
            this.channel = DisconnectTest.createChannel();
            DisconnectTest.setProps(this.channel);
            this.channel.connect("testConnectTwo_TUNNEL");
            View view = this.channel.getView();
            for (int i = 0; i < 10 && view.size() < 2; ++i) {
                System.out.print(".");
                Util.sleep(1000L);
                view = this.channel.getView();
            }
            System.out.println("view = " + view);
            DisconnectTest.assertEquals((int)2, (int)view.size());
            DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
            DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
            this.channel.close();
            coordinator.close();
        }
        finally {
            if (router != null) {
                router.stop();
                Util.sleep(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisconnectConnectTwo_TUNNEL() throws Exception {
        GossipRouter router = null;
        try {
            router = new GossipRouter();
            router.start();
            JChannel coordinator = DisconnectTest.createChannel();
            DisconnectTest.setProps(coordinator);
            coordinator.connect("testgroup");
            this.channel = DisconnectTest.createChannel();
            DisconnectTest.setProps(this.channel);
            this.channel.connect("testgroup1");
            this.channel.disconnect();
            this.channel.connect("testgroup");
            View view = this.channel.getView();
            for (int i = 0; i < 10 && view.size() < 2; ++i) {
                System.out.print(".");
                Util.sleep(1000L);
                view = this.channel.getView();
            }
            DisconnectTest.assertEquals((int)2, (int)view.size());
            DisconnectTest.assertTrue((boolean)view.containsMember(this.channel.getLocalAddress()));
            DisconnectTest.assertTrue((boolean)view.containsMember(coordinator.getLocalAddress()));
            this.channel.close();
            coordinator.close();
        }
        finally {
            if (router != null) {
                router.stop();
                Util.sleep(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDisconnectConnectSendTwo_TUNNEL() throws Exception {
        GossipRouter router = null;
        try {
            router = new GossipRouter();
            router.start();
            Promise msgPromise = new Promise();
            JChannel coordinator = DisconnectTest.createChannel();
            DisconnectTest.setProps(coordinator);
            coordinator.setReceiver(new PromisedMessageListener(msgPromise));
            coordinator.connect("testgroup");
            this.channel = DisconnectTest.createChannel();
            DisconnectTest.setProps(this.channel);
            this.channel.connect("testgroup1");
            this.channel.disconnect();
            this.channel.connect("testgroup");
            this.channel.send(new Message(null, null, (Serializable)((Object)"payload")));
            Message msg = (Message)msgPromise.getResult(20000L);
            DisconnectTest.assertNotNull((Object)msg);
            DisconnectTest.assertEquals((Object)"payload", (Object)msg.getObject());
            this.channel.close();
            coordinator.close();
        }
        finally {
            if (router != null) {
                router.stop();
                Util.sleep(1000L);
            }
        }
    }

    private static void setProps(JChannel channel) {
        PING ping;
        TUNNEL tunnel;
        ProtocolStack stack = channel.getProtocolStack();
        MERGE2 merge = (MERGE2)stack.findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(1000L);
            merge.setMaxInterval(3000L);
        }
        if ((tunnel = (TUNNEL)stack.getTransport()) != null) {
            tunnel.setReconnectInterval(2000L);
        }
        if ((ping = (PING)stack.findProtocol(PING.class)) != null) {
            ping.setGossipRefresh(1000L);
        }
    }

    public static Test suite() {
        return new TestSuite(DisconnectTest.class);
    }

    private static class PromisedMessageListener
    extends ReceiverAdapter {
        private final Promise promise;

        public PromisedMessageListener(Promise promise) {
            this.promise = promise;
        }

        public void receive(Message msg) {
            this.promise.setResult(msg);
        }
    }
}

