/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractItemDefinitionAccessProvider;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeReadException;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;

public class NodeDefinitionAccessProvider
extends AbstractItemDefinitionAccessProvider {
    public NodeDefinitionAccessProvider(DataManager dataManager) {
        super(dataManager);
    }

    public NodeDefinitionData read(NodeData childDefinition, InternalQName declaringNodeType) throws NodeTypeReadException, RepositoryException {
        InternalQName name = this.readName(childDefinition, Constants.JCR_NAME);
        boolean autoCreated = this.readMandatoryBoolean(childDefinition, Constants.JCR_AUTOCREATED);
        boolean mandatory = this.readMandatoryBoolean(childDefinition, Constants.JCR_MANDATORY);
        int onParentVersion = OnParentVersionAction.valueFromName((String)this.readMandatoryString(childDefinition, Constants.JCR_ONPARENTVERSION));
        boolean protectedItem = this.readMandatoryBoolean(childDefinition, Constants.JCR_PROTECTED);
        InternalQName[] requiredPrimaryTypes = this.readNames(childDefinition, Constants.JCR_REQUIREDPRIMARYTYPES);
        InternalQName defaultPrimaryType = this.readName(childDefinition, Constants.JCR_DEFAULTPRIMNARYTYPE);
        boolean allowsSameNameSiblings = this.readMandatoryBoolean(childDefinition, Constants.JCR_SAMENAMESIBLINGS);
        return new NodeDefinitionData(name, declaringNodeType, autoCreated, mandatory, onParentVersion, protectedItem, requiredPrimaryTypes, defaultPrimaryType, allowsSameNameSiblings);
    }

    public void write(PlainChangesLog changesLog, NodeData ntNode, NodeDefinitionData nodeDefinitionData, int index) {
        TransientNodeData childNodesDefinition = TransientNodeData.createNodeData(ntNode, Constants.JCR_CHILDNODEDEFINITION, Constants.NT_CHILDNODEDEFINITION, index);
        changesLog.add(ItemState.createAddedState(childNodesDefinition));
        this.writeItemDefinition(changesLog, childNodesDefinition, nodeDefinitionData);
        this.writeName(changesLog, childNodesDefinition, Constants.JCR_PRIMARYTYPE, childNodesDefinition.getPrimaryTypeName());
        this.writeBoolean(changesLog, childNodesDefinition, Constants.JCR_SAMENAMESIBLINGS, nodeDefinitionData.isAllowsSameNameSiblings());
        if (nodeDefinitionData.getDefaultPrimaryType() != null) {
            this.writeName(changesLog, childNodesDefinition, Constants.JCR_DEFAULTPRIMNARYTYPE, nodeDefinitionData.getDefaultPrimaryType());
        }
        if (nodeDefinitionData.getRequiredPrimaryTypes() != null && nodeDefinitionData.getRequiredPrimaryTypes().length != 0) {
            this.writeNames(changesLog, childNodesDefinition, Constants.JCR_REQUIREDPRIMARYTYPES, nodeDefinitionData.getRequiredPrimaryTypes());
        }
    }
}

