/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.filters.Util;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;
import org.exoplatform.social.common.xmlprocessor.model.XMLTagFilterPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTagFilterPlugin
extends BaseXMLFilterPlugin {
    private LinkedHashMap<String, Attributes> allowedTags;

    public LinkedHashMap<String, Attributes> getAllowedTags() {
        return this.allowedTags;
    }

    public void setAllowedTags(LinkedHashMap<String, Attributes> allowedTags) {
        this.allowedTags = allowedTags;
    }

    public XMLTagFilterPlugin(XMLTagFilterPolicy tagFilterPolicy) {
        this.allowedTags = Util.getAllowedTagsFromTagFilterPolicy(tagFilterPolicy);
    }

    @Override
    public Object doFilter(Object input) {
        if (input instanceof String) {
            input = this.nodeFilter((String)input);
        }
        return input;
    }

    private String nodeFilter(String xmlInput) {
        List<String> xmlTokens = Tokenizer.tokenize(xmlInput);
        for (int i = 0; i < xmlTokens.size(); ++i) {
            String tag;
            String token = xmlTokens.get(i);
            Matcher startMatcher = DOMParser.TAGSTARTPATTERN.matcher(token);
            Matcher endMatcher = DOMParser.TAGCLOSEPATTERN.matcher(token);
            if (startMatcher.find()) {
                tag = startMatcher.group(1).toLowerCase();
                if (!this.allowedTags.containsKey(tag)) {
                    xmlTokens.set(i, StringEscapeUtils.escapeHtml((String)token));
                    continue;
                }
                StringBuilder tagStringBuilder = new StringBuilder("<" + tag);
                String tokenBody = startMatcher.group(2);
                Matcher attributes = DOMParser.ATTRIBUTESPATTERN.matcher(tokenBody);
                Attributes attributesWhiteList = this.allowedTags.get(tag);
                while (attributes.find()) {
                    String val;
                    String attr = attributes.group(1).toLowerCase();
                    String string = val = attributes.group(4) == null ? attributes.group(3) : attributes.group(4);
                    if (!attributesWhiteList.hasKey(attr)) continue;
                    tagStringBuilder.append(" " + attr + "=" + "\"" + val + "\"");
                }
                if (DOMParser.SELFTCLOSETAGPATTERN.matcher(token).find()) {
                    tagStringBuilder.append(" />");
                } else {
                    tagStringBuilder.append(">");
                }
                xmlTokens.set(i, tagStringBuilder.toString());
                continue;
            }
            if (!endMatcher.find() || this.allowedTags.containsKey(tag = endMatcher.group(1).toLowerCase())) continue;
            xmlTokens.set(i, StringEscapeUtils.escapeHtml((String)token));
        }
        StringBuilder xmlStringBuilder = new StringBuilder();
        for (String xmlToken : xmlTokens) {
            xmlStringBuilder.append(xmlToken);
        }
        return xmlStringBuilder.toString();
    }
}

