/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Escapable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactoryImpl;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactoryImpl;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.util.Constants;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarBuilder
implements ContentHandler {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private Log log = LogFactory.getLog((Class)CalendarBuilder.class);
    private CalendarParser parser;
    private TimeZoneRegistry registry;
    protected Calendar calendar;
    protected Component component;
    protected Component subComponent;
    protected Property property;
    protected ArrayList datesMissingTimezones;

    public CalendarBuilder() {
        this(CalendarParserFactory.getInstance().createParser(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(CalendarParser parser) {
        this(parser, TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(TimeZoneRegistry registry) {
        this(CalendarParserFactory.getInstance().createParser(), registry);
    }

    public CalendarBuilder(CalendarParser parser, TimeZoneRegistry registry) {
        this.parser = parser;
        this.registry = registry;
    }

    public Calendar build(InputStream in) throws IOException, ParserException {
        return this.build(new InputStreamReader(in, DEFAULT_CHARSET));
    }

    public Calendar build(Reader in) throws IOException, ParserException {
        return this.build(new UnfoldingReader(in));
    }

    public Calendar build(UnfoldingReader uin) throws IOException, ParserException {
        this.calendar = null;
        this.component = null;
        this.subComponent = null;
        this.property = null;
        this.datesMissingTimezones = new ArrayList();
        this.parser.parse(uin, (ContentHandler)this);
        if (this.datesMissingTimezones.size() > 0 && this.registry != null) {
            this.resolveTimezones();
        }
        return this.calendar;
    }

    public void endCalendar() {
    }

    public void endComponent(String name) {
        if (this.component != null) {
            if (this.subComponent != null) {
                if (this.component instanceof VTimeZone) {
                    ((VTimeZone)this.component).getObservances().add(this.subComponent);
                } else if (this.component instanceof VEvent) {
                    ((VEvent)this.component).getAlarms().add(this.subComponent);
                } else if (this.component instanceof VToDo) {
                    ((VToDo)this.component).getAlarms().add(this.subComponent);
                } else if (this.component instanceof VAvailability) {
                    ((VAvailability)this.component).getAvailable().add(this.subComponent);
                }
                this.subComponent = null;
            } else {
                this.calendar.getComponents().add(this.component);
                if (this.component instanceof VTimeZone && this.registry != null) {
                    this.registry.register(new TimeZone((VTimeZone)this.component));
                }
                this.component = null;
            }
        }
    }

    public void endProperty(String name) {
        if (this.property != null) {
            this.property = Constants.forProperty(this.property);
            if (this.component != null) {
                if (this.subComponent != null) {
                    this.subComponent.getProperties().add(this.property);
                } else {
                    this.component.getProperties().add(this.property);
                }
            } else if (this.calendar != null) {
                this.calendar.getProperties().add(this.property);
            }
            this.property = null;
        }
    }

    public void parameter(String name, String value) throws URISyntaxException {
        if (this.property != null) {
            Parameter param = ParameterFactoryImpl.getInstance().createParameter(name.toUpperCase(), value);
            this.property.getParameters().add(param);
            if (param instanceof TzId && this.registry != null) {
                TimeZone timezone = this.registry.getTimeZone(param.getValue());
                if (timezone != null) {
                    try {
                        ((DateProperty)this.property).setTimeZone(timezone);
                    }
                    catch (Exception e) {
                        try {
                            ((DateListProperty)this.property).setTimeZone(timezone);
                        }
                        catch (Exception e2) {
                            this.log.warn((Object)("Error setting timezone [" + param + "] on property [" + this.property.getName() + "]"), (Throwable)e);
                        }
                    }
                } else {
                    this.datesMissingTimezones.add(this.property);
                }
            }
        }
    }

    public void propertyValue(String value) throws URISyntaxException, ParseException, IOException {
        if (this.property != null) {
            if (this.property instanceof Escapable) {
                this.property.setValue(Strings.unescape(value));
            } else {
                this.property.setValue(value);
            }
        }
    }

    public void startCalendar() {
        this.calendar = new Calendar();
    }

    public void startComponent(String name) {
        if (this.component != null) {
            this.subComponent = ComponentFactory.getInstance().createComponent(name);
        } else {
            this.component = ComponentFactory.getInstance().createComponent(name);
        }
    }

    public void startProperty(String name) {
        this.property = PropertyFactoryImpl.getInstance().createProperty(name.toUpperCase());
    }

    public final TimeZoneRegistry getRegistry() {
        return this.registry;
    }

    private void resolveTimezones() throws IOException {
        Iterator it = this.datesMissingTimezones.iterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            Parameter tzParam = property.getParameter("TZID");
            TimeZone timezone = this.registry.getTimeZone(tzParam.getValue());
            if (timezone == null) continue;
            String strDate = property.getValue();
            if (property instanceof DateProperty) {
                ((DateProperty)property).setTimeZone(timezone);
            } else if (property instanceof DateListProperty) {
                ((DateListProperty)property).setTimeZone(timezone);
            }
            try {
                property.setValue(strDate);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

