/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.content.interceptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xcmis.search.Startable;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.VisitableCommand;
import org.xcmis.search.content.interceptors.CommandInterceptor;

public class InterceptorChain
implements Startable {
    private CommandInterceptor firstInChain;
    private static final Log log = LogFactory.getLog(InterceptorChain.class);

    public InterceptorChain(CommandInterceptor first) {
        this.firstInChain = first;
    }

    public synchronized boolean addAfterInterceptor(CommandInterceptor toAdd, Class<? extends CommandInterceptor> afterInterceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (!it.getClass().equals(afterInterceptor)) continue;
            toAdd.setNext(it.getNext());
            it.setNext(toAdd);
            return true;
        }
        return false;
    }

    public synchronized boolean addBeforeInterceptor(CommandInterceptor toAdd, Class<? extends CommandInterceptor> beforeInterceptor) {
        if (this.firstInChain.getClass().equals(beforeInterceptor) || beforeInterceptor.isAssignableFrom(this.firstInChain.getClass())) {
            toAdd.setNext(this.firstInChain);
            this.firstInChain = toAdd;
            return true;
        }
        CommandInterceptor it = this.firstInChain;
        while (it.getNext() != null) {
            if (it.getNext().getClass().equals(beforeInterceptor)) {
                toAdd.setNext(it.getNext());
                it.setNext(toAdd);
                return true;
            }
            it = it.getNext();
        }
        return false;
    }

    public synchronized void addInterceptor(CommandInterceptor interceptor, int position) {
        if (position == 0) {
            interceptor.setNext(this.firstInChain);
            this.firstInChain = interceptor;
            return;
        }
        if (this.firstInChain == null) {
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            interceptor.setNext(it.getNext());
            it.setNext(interceptor);
            return;
        }
        throw new IllegalArgumentException("Invalid index: " + index + " !");
    }

    public void appendIntereceptor(CommandInterceptor ci) {
        CommandInterceptor it = this.firstInChain;
        while (it.hasNext()) {
            it = it.getNext();
        }
        it.setNext(ci);
        ci.setNext(null);
    }

    public List<CommandInterceptor> asList() {
        if (this.firstInChain == null) {
            return Collections.emptyList();
        }
        LinkedList<CommandInterceptor> retval = new LinkedList<CommandInterceptor>();
        CommandInterceptor tmp = this.firstInChain;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return Collections.unmodifiableList(retval);
    }

    public boolean containsInstance(CommandInterceptor interceptor) {
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (it != interceptor) continue;
            return true;
        }
        return false;
    }

    public CommandInterceptor getFirstInChain() {
        return this.firstInChain;
    }

    public String getInterceptorDetails() {
        StringBuilder sb = new StringBuilder("Interceptor chain: \n");
        int count = 0;
        for (CommandInterceptor i : this.asList()) {
            sb.append("   ").append(++count).append(". ").append(i).append("\n");
        }
        return sb.toString();
    }

    public List<CommandInterceptor> getInterceptorsWhichExtend(Class<? extends CommandInterceptor> interceptorClass) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>();
        for (CommandInterceptor interceptor : this.asList()) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            result.add(interceptor);
        }
        return result;
    }

    public List<CommandInterceptor> getInterceptorsWithClassName(String fqName) {
        ArrayList<CommandInterceptor> result = new ArrayList<CommandInterceptor>(2);
        for (CommandInterceptor iterator = this.firstInChain; iterator != null; iterator = iterator.getNext()) {
            if (!iterator.getClass().getName().equals(fqName)) continue;
            result.add(iterator);
        }
        return result;
    }

    public Object invoke(InvocationContext ctx, VisitableCommand command) throws Throwable {
        try {
            return command.acceptVisitor(ctx, this.firstInChain);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public synchronized void removeInterceptor(Class<? extends CommandInterceptor> clazz) {
        if (this.firstInChain.getClass() == clazz) {
            this.firstInChain = this.firstInChain.getNext();
        }
        CommandInterceptor prevIt = this.firstInChain;
        for (CommandInterceptor it = this.firstInChain.getNext(); it != null; it = it.getNext()) {
            if (it.getClass() == clazz) {
                prevIt.setNext(it.getNext());
            }
            prevIt = it;
        }
    }

    public synchronized void removeInterceptor(int position) {
        if (this.firstInChain == null) {
            return;
        }
        if (position == 0) {
            this.firstInChain = this.firstInChain.getNext();
            return;
        }
        int index = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            if (++index != position) continue;
            if (it.getNext() == null) {
                return;
            }
            it.setNext(it.getNext().getNext());
            return;
        }
        throw new IllegalArgumentException("Invalid position: " + position + " !");
    }

    public void setFirstInChain(CommandInterceptor interceptor) {
        this.firstInChain = interceptor;
    }

    public int size() {
        int size = 0;
        for (CommandInterceptor it = this.firstInChain; it != null; it = it.getNext()) {
            ++size;
        }
        return size;
    }

    @Override
    public void start() {
        for (CommandInterceptor interceptor : this.asList()) {
            interceptor.start();
        }
    }

    @Override
    public void stop() {
        for (CommandInterceptor interceptor : this.asList()) {
            interceptor.stop();
        }
    }

    void printChainInfo() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Interceptor chain is: " + this.toString()));
        }
    }
}

