/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.Directory;
import org.xcmis.search.Startable;
import org.xcmis.search.lucene.index.FieldNames;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.IndexTransactionModificationReportImpl;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.spi.utils.Logger;

public class PersistedIndex
implements LuceneIndexDataManager,
Startable {
    private static final Logger LOG = Logger.getLogger(PersistedIndex.class);
    private final Directory indexDirectiry;
    private IndexReader indexReader;
    private long lastModifedTime;

    public PersistedIndex(Directory directory) {
        this.indexDirectiry = directory;
        this.lastModifedTime = System.currentTimeMillis();
    }

    @Override
    public Directory getDirectory() throws IndexException {
        return this.indexDirectiry;
    }

    @Override
    public long getDirectorySize(boolean includeInherited) {
        int result = 0;
        try {
            String[] list;
            for (String element : list = this.indexDirectiry.list()) {
                result = (int)((long)result + this.indexDirectiry.fileLength(element));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Document getDocument(String uuid) throws IndexException {
        IndexReader reader = this.getIndexReader();
        return this.getDocument(uuid, reader);
    }

    @Override
    public long getDocumentCount() {
        try {
            return this.getIndexReader().numDocs();
        }
        catch (IndexException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public IndexReader getIndexReader() throws IndexException {
        try {
            if (this.indexReader == null) {
                this.indexReader = IndexReader.open((Directory)this.indexDirectiry);
            } else if (!this.indexReader.isCurrent()) {
                this.indexReader = this.indexReader.reopen();
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return this.indexReader;
    }

    @Override
    public long getLastModifedTime() {
        return this.lastModifedTime;
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public boolean isStoped() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException {
        HashSet<String> removedDocuments = new HashSet<String>();
        HashSet<String> updatedDocuments = new HashSet<String>();
        try {
            Directory directory = this.indexDirectiry;
            synchronized (directory) {
                Set<String> removed = changes.getRemovedDocuments();
                IndexWriter writer = null;
                IndexReader reader = null;
                Map updated = null;
                for (String removedUuid : removed) {
                    if (reader == null) {
                        reader = this.getIndexReader();
                    }
                    if (this.getDocument(removedUuid, reader) == null) continue;
                    removedDocuments.add(removedUuid);
                }
                if (removedDocuments.size() > 0 || changes.getAddedDocuments().size() > 0) {
                    writer = new IndexWriter(this.indexDirectiry, (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                    for (String uuid : removedDocuments) {
                        writer.deleteDocuments(new Term(FieldNames.UUID, uuid));
                    }
                    for (String uuid : updatedDocuments) {
                        writer.updateDocument(new Term(FieldNames.UUID, uuid), (Document)updated.get(uuid));
                    }
                    for (Document document : changes.getAddedDocuments().values()) {
                        writer.addDocument(document);
                    }
                    writer.commit();
                    writer.close();
                    this.lastModifedTime = System.currentTimeMillis();
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return new IndexTransactionModificationReportImpl(changes.getAddedDocuments().keySet(), removedDocuments, updatedDocuments);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        try {
            this.indexReader.close();
            this.indexDirectiry.close();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Document getDocument(String uuid, IndexReader reader) throws IndexException {
        try {
            TermDocs termDocs = reader.termDocs(new Term(FieldNames.UUID, uuid));
            if (termDocs.next()) {
                Document document = reader.document(termDocs.doc());
                if (termDocs.next()) {
                    throw new IndexException("More then one document found for uuid:" + uuid);
                }
                return document;
            }
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return null;
    }
}

