/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.AggregatePolicy;
import org.xcmis.spi.utils.Logger;

public class IndexSizeAggregatePolicy
implements AggregatePolicy {
    private final Logger log = Logger.getLogger(IndexSizeAggregatePolicy.class);
    public static final int DEFAULT_MAX_DIR_SIZE = 0x100000;
    public static final int DEFAULT_MIN_DIR_SIZE = 0;
    private int maxDirSize = 0x100000;
    private int minDirSize = 0;

    public int getMinDirSize() {
        return this.minDirSize;
    }

    public void setMinDirSize(int minDirSize) {
        this.minDirSize = minDirSize;
    }

    public int getMaxDirSize() {
        return this.maxDirSize;
    }

    public void setMaxDirSize(int maxDirSize) {
        this.maxDirSize = maxDirSize;
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        Collection<Object> result = null;
        if (requiredCandidatCount == 0L && reguiredTotalCandidatSize == 0L) {
            result = new ArrayList();
            for (LuceneIndexDataManager luceneIndexDataManager : aggregateCandidat) {
                if ((long)this.minDirSize >= luceneIndexDataManager.getDirectorySize(false) || luceneIndexDataManager.getDirectorySize(false) >= (long)this.maxDirSize) continue;
                result.add(luceneIndexDataManager);
            }
        } else if (requiredCandidatCount < (long)aggregateCandidat.size()) {
            result = new ArrayList((int)requiredCandidatCount);
            LuceneIndexDataManager[] indexes = new LuceneIndexDataManager[aggregateCandidat.size()];
            aggregateCandidat.toArray(indexes);
            Arrays.sort(indexes, new IndexSizeComparator());
            int i = 0;
            while ((long)i < requiredCandidatCount) {
                result.add(indexes[i]);
                ++i;
            }
        } else {
            result = aggregateCandidat;
        }
        return result;
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToOptimize(Collection<LuceneIndexDataManager> aggregateCandidat) {
        return null;
    }

    private class IndexSizeComparator
    implements Comparator<LuceneIndexDataManager> {
        private IndexSizeComparator() {
        }

        @Override
        public int compare(LuceneIndexDataManager o1, LuceneIndexDataManager o2) {
            return (int)(o1.getDirectorySize(false) - o2.getDirectorySize(false));
        }
    }
}

