/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;
import org.icepdf.core.pobjects.security.SecurityManager;

public class PInfo {
    private Hashtable attributes = null;
    private SecurityManager securityManager;

    public PInfo(SecurityManager securityManager, Hashtable attributes) {
        this.attributes = attributes;
        this.securityManager = securityManager;
    }

    public Object getCustomExtension(String name) {
        return this.attributes.get(name);
    }

    public String getTitle() {
        Object tmp = this.attributes.get("Title");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public String getAuthor() {
        Object tmp = this.attributes.get("Author");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public String getSubject() {
        Object tmp = this.attributes.get("Subject");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public String getKeywords() {
        Object tmp = this.attributes.get("Keywords");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public String getCreator() {
        Object tmp = this.attributes.get("Creator");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public String getProducer() {
        Object tmp = this.attributes.get("Producer");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    public PDate getCreationDate() {
        Object tmp = this.attributes.get("CreationDate");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        return null;
    }

    public PDate getModDate() {
        Object tmp = this.attributes.get("ModDate");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return new PDate(this.securityManager, text.getDecryptedLiteralString(this.securityManager));
        }
        return null;
    }

    public String getTrappingInformation() {
        Object tmp = this.attributes.get("Trapped");
        if (tmp != null && tmp instanceof StringObject) {
            StringObject text = (StringObject)tmp;
            return this.cleanString(text.getDecryptedLiteralString(this.securityManager));
        }
        return "";
    }

    private String cleanString(String text) {
        if (text != null && text.length() > 0) {
            if (text.charAt(0) == '\u00fe' && text.charAt(1) == '\u00ff') {
                StringBuilder sb1 = new StringBuilder();
                String hexTmp = "";
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\t' || c == '\r' || c == '\n') continue;
                    hexTmp = hexTmp + text.charAt(i);
                }
                byte[] title1 = hexTmp.getBytes();
                for (int i = 2; i < title1.length; i += 2) {
                    try {
                        int b1 = title1[i] & 0xFF;
                        int b2 = title1[i + 1] & 0xFF;
                        sb1.append((char)(b1 * 256 + b2));
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                text = sb1.toString();
            } else {
                StringBuilder sb = new StringBuilder();
                Encoding enc = Encoding.getPDFDoc();
                for (int i = 0; i < text.length(); ++i) {
                    sb.append(enc.get(text.charAt(i)));
                }
                text = sb.toString();
            }
            return text;
        }
        return "";
    }
}

