/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag.query;

import org.icepdf.core.tag.query.Expression;

public abstract class Operator
implements Expression {
    public static int SCOPE_TAG = 1;
    public static int SCOPE_IMAGE = 2;
    private static final String[] SCOPE_NAMES = new String[]{"", "TAG", "IMAGE"};
    protected int scope;
    protected Expression[] childExpressions;

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public void setChildExpressions(Expression[] children) {
        this.childExpressions = children;
    }

    public String describe(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        sb.append(className);
        sb.append("  scope: ");
        sb.append(SCOPE_NAMES[this.scope]);
        sb.append('\n');
        int num = this.childExpressions != null ? this.childExpressions.length : 0;
        for (int i = 0; i < num; ++i) {
            sb.append(this.childExpressions[i].describe(indent + 1));
        }
        return sb.toString();
    }
}

