/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.session;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.web.servlet.JSecurityHttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSession
implements Session {
    private static final String INET_ADDRESS_SESSION_KEY = WebSession.class.getName() + "_INET_ADDRESS_SESSION_KEY";
    private static final String TOUCH_OBJECT_SESSION_KEY = WebSession.class.getName() + "_TOUCH_OBJECT_SESSION_KEY";
    private HttpSession httpSession = null;

    public WebSession(HttpSession httpSession, InetAddress inetAddress) {
        if (httpSession == null) {
            String msg = "HttpSession constructor argument cannot be null.";
            throw new IllegalArgumentException(msg);
        }
        if (httpSession instanceof JSecurityHttpSession) {
            String msg = "HttpSession constructor argument cannot be an instance of JSecurityHttpSession.  This is enforced to prevent circular dependencies and infinite loops.";
            throw new IllegalArgumentException(msg);
        }
        this.httpSession = httpSession;
        if (inetAddress != null) {
            this.setHostAddress(inetAddress);
        }
    }

    @Override
    public Serializable getId() {
        return this.httpSession.getId();
    }

    @Override
    public Date getStartTimestamp() {
        return new Date(this.httpSession.getCreationTime());
    }

    @Override
    public Date getLastAccessTime() {
        return new Date(this.httpSession.getLastAccessedTime());
    }

    @Override
    public long getTimeout() throws InvalidSessionException {
        try {
            return this.httpSession.getMaxInactiveInterval() * 1000;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void setTimeout(long maxIdleTimeInMillis) throws InvalidSessionException {
        try {
            int timeout = Long.valueOf(maxIdleTimeInMillis / 1000L).intValue();
            this.httpSession.setMaxInactiveInterval(timeout);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    protected void setHostAddress(InetAddress hostAddress) {
        this.setAttribute(INET_ADDRESS_SESSION_KEY, hostAddress);
    }

    @Override
    public InetAddress getHostAddress() {
        return (InetAddress)this.getAttribute(INET_ADDRESS_SESSION_KEY);
    }

    @Override
    public void touch() throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(TOUCH_OBJECT_SESSION_KEY, (Object)TOUCH_OBJECT_SESSION_KEY);
            this.httpSession.removeAttribute(TOUCH_OBJECT_SESSION_KEY);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void stop() throws InvalidSessionException {
        try {
            this.httpSession.invalidate();
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        try {
            Enumeration namesEnum = this.httpSession.getAttributeNames();
            ArrayList keys = null;
            if (namesEnum != null) {
                keys = new ArrayList();
                while (namesEnum.hasMoreElements()) {
                    keys.add(namesEnum.nextElement());
                }
            }
            return keys;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    private static String assertString(Object key) {
        if (!(key instanceof String)) {
            String msg = "HttpSession based implementations of the JSecurity Session interface requires attribute keys to be String objects.  The HttpSession class does not support anything other than String keys.";
            throw new IllegalArgumentException(msg);
        }
        return (String)key;
    }

    @Override
    public Object getAttribute(Object key) throws InvalidSessionException {
        try {
            return this.httpSession.getAttribute(WebSession.assertString(key));
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public void setAttribute(Object key, Object value) throws InvalidSessionException {
        try {
            this.httpSession.setAttribute(WebSession.assertString(key), value);
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }

    @Override
    public Object removeAttribute(Object key) throws InvalidSessionException {
        try {
            String sKey = WebSession.assertString(key);
            Object removed = this.httpSession.getAttribute(sKey);
            this.httpSession.removeAttribute(sKey);
            return removed;
        }
        catch (Exception e) {
            throw new InvalidSessionException(e);
        }
    }
}

