/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.uistate.rest;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.uistate.UIStateSession;
import org.exoplatform.services.uistate.bean.UIStateDataBean;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;

@Path(value="/uistateservice")
public class UIStateService
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger((String)"cs.chat.uistateservice");
    private static final CacheControl cc;

    @POST
    @Path(value="/save/{username}/{unreadMessageCnt}")
    @Produces(value={"application/json"})
    public Response saveState(@PathParam(value="username") String userName, @PathParam(value="unreadMessageCnt") String unreadMessageCnt, UIStateDataBean stateData) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
            if (messenger != null) {
                UIStateSession uiSession = messenger.getUISateSession(userName);
                stateData = stateData != null ? stateData : new UIStateDataBean();
                uiSession.setUIStateData(stateData);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("saving UI state failed for user: " + userName), (Throwable)e);
            }
            return Response.serverError().cacheControl(cc).build();
        }
        UIStateDataBean stateDataBean = new UIStateDataBean("null");
        stateDataBean.setUnreadMessageCnt(unreadMessageCnt);
        return Response.ok((Object)stateDataBean, (String)"application/json").cacheControl(cc).build();
    }

    @GET
    @Path(value="/get/{username}/")
    @Produces(value={"application/json"})
    public Response getState(@PathParam(value="username") String userName) throws Exception {
        block4: {
            try {
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
                if (messenger != null) {
                    UIStateSession uiSession = messenger.getUISateSession(userName);
                    UIStateDataBean uiStateData = uiSession.getUIStateData();
                    if (uiStateData == null || uiStateData.getData() == null) {
                        return Response.noContent().cacheControl(cc).build();
                    }
                    return Response.ok((Object)uiStateData, (String)"application/json").cacheControl(cc).build();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Getting UIStage failed for user: " + userName), (Throwable)e);
            }
        }
        return Response.serverError().cacheControl(cc).build();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

