/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.search.ExcludeIncludeDataTypePlugin;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.services.wcm.utils.AbstractQueryBuilder;
import org.exoplatform.services.wcm.utils.SQLQueryBuilder;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class SiteSearchServiceImpl
implements SiteSearchService {
    private static final String IS_ENABLED_FUZZY_SEARCH = "isEnabledFuzzySearch";
    private static final String FUZZY_SEARCH_INDEX = "fuzzySearchIndex";
    protected LivePortalManagerService livePortalManagerService;
    protected TemplateService templateService;
    protected WCMConfigurationService configurationService;
    protected RepositoryService repositoryService;
    private CopyOnWriteArraySet<String> excludeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> excludeMimeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeMimeTypes = new CopyOnWriteArraySet();
    private boolean isEnabledFuzzySearch = true;
    private double fuzzySearchIndex = 0.8;

    public SiteSearchServiceImpl(LivePortalManagerService portalManagerService, TemplateService templateService, WCMConfigurationService configurationService, RepositoryService repositoryService, InitParams initParams) throws Exception {
        this.livePortalManagerService = portalManagerService;
        this.templateService = templateService;
        this.repositoryService = repositoryService;
        this.configurationService = configurationService;
        if (initParams != null) {
            ValueParam enabledFuzzySearchValue;
            ValueParam isEnabledFuzzySearchValue = initParams.getValueParam(IS_ENABLED_FUZZY_SEARCH);
            if (isEnabledFuzzySearchValue != null) {
                this.isEnabledFuzzySearch = Boolean.parseBoolean(isEnabledFuzzySearchValue.getValue());
            }
            if ((enabledFuzzySearchValue = initParams.getValueParam(FUZZY_SEARCH_INDEX)) != null) {
                try {
                    this.fuzzySearchIndex = Double.parseDouble(enabledFuzzySearchValue.getValue());
                }
                catch (NumberFormatException e) {
                    this.fuzzySearchIndex = 0.8;
                }
            }
            if (this.fuzzySearchIndex < 0.0 || this.fuzzySearchIndex >= 1.0) {
                this.fuzzySearchIndex = 0.8;
            }
        }
    }

    public void addExcludeIncludeDataTypePlugin(ExcludeIncludeDataTypePlugin plugin) {
        this.excludeNodeTypes.addAll(plugin.getExcludeNodeTypes());
        this.excludeMimeTypes.addAll(plugin.getExcludeMimeTypes());
        this.includeMimeTypes.addAll(plugin.getIncludeMimeTypes());
        this.includeNodeTypes.addAll(plugin.getIncludeNodeTypes());
    }

    public WCMPaginatedQueryResult searchSiteContents(SessionProvider sessionProvider, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        int limit;
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        NodeLocation location = this.configurationService.getLivePortalsLocation(currentRepository.getConfiguration().getName());
        long startTime = System.currentTimeMillis();
        String pageMode = queryCriteria.getPageMode();
        boolean showTotalPagination = "pagination".equals(pageMode);
        long numTotal = 0L;
        int n = limit = "none".equals(pageMode) ? pageSize : pageSize + 1;
        if (showTotalPagination) {
            SessionProvider systemProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = systemProvider.getSession(location.getWorkspace(), currentRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryResult queryResult = this.searchSiteContent(queryCriteria, queryManager);
            numTotal = queryResult.getNodes().getSize();
            --limit;
        }
        Session session = sessionProvider.getSession(location.getWorkspace(), currentRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        long offset = 0L;
        if (queryCriteria.getOffset() > -1L) {
            offset = queryCriteria.getOffset();
        }
        QueryResult queryResult = this.searchSiteContent(queryCriteria, queryManager, limit, offset);
        if (!showTotalPagination) {
            numTotal = queryResult.getNodes().getSize();
        }
        String suggestion = this.getSpellSuggestion(queryCriteria.getKeyword(), currentRepository);
        long queryTime = System.currentTimeMillis() - startTime;
        WCMPaginatedQueryResult paginatedQueryResult = null;
        paginatedQueryResult = new WCMPaginatedQueryResult(queryResult, queryCriteria, pageSize, numTotal, showTotalPagination, isSearchContent);
        paginatedQueryResult.setQueryTime(queryTime);
        paginatedQueryResult.setSpellSuggestion(suggestion);
        return paginatedQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSpellSuggestion(String checkingWord, ManageableRepository manageableRepository) throws Exception {
        String suggestion = null;
        Session session = null;
        try {
            session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getDefaultWorkspaceName());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT rep:spellcheck() FROM nt:base WHERE jcr:path like '/' AND SPELLCHECK('" + checkingWord + "')", "sql");
            RowIterator rows = query.execute().getRows();
            Value value = rows.nextRow().getValue("rep:spellcheck()");
            if (value != null) {
                suggestion = value.getString();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return suggestion;
    }

    protected QueryResult searchSiteContent(QueryCriteria queryCriteria, QueryManager queryManager) throws Exception {
        return this.searchSiteContent(queryCriteria, queryManager, -1L, -1L);
    }

    protected QueryResult searchSiteContent(QueryCriteria queryCriteria, QueryManager queryManager, long limit, long offset) throws Exception {
        SQLQueryBuilder queryBuilder = new SQLQueryBuilder();
        this.mapQueryTypes(queryCriteria, queryBuilder);
        if (queryCriteria.isFulltextSearch()) {
            this.mapQueryPath(queryCriteria, queryBuilder);
            this.mapFulltextQueryTearm(queryCriteria, queryBuilder);
        } else {
            this.searchByNodeName(queryCriteria, queryBuilder);
        }
        this.mapCategoriesCondition(queryCriteria, queryBuilder);
        this.mapDatetimeRangeSelected(queryCriteria, queryBuilder);
        this.mapMetadataProperties(queryCriteria, queryBuilder);
        this.orderBy(queryCriteria, queryBuilder);
        String queryStatement = queryBuilder.createQueryStatement();
        Query query = queryManager.createQuery(queryStatement, "sql");
        if (limit > -1L && offset > -1L) {
            ((QueryImpl)query).setLimit(limit);
            ((QueryImpl)query).setOffset(offset);
        }
        return query.execute();
    }

    private void mapQueryPath(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.setQueryPath(this.getSitePath(queryCriteria), AbstractQueryBuilder.PATH_TYPE.DECENDANTS);
    }

    private String getSitePath(QueryCriteria queryCriteria) throws Exception {
        String siteName = queryCriteria.getSiteName();
        String sitePath = null;
        if (siteName != null) {
            sitePath = this.livePortalManagerService.getPortalPathByName(siteName);
        } else {
            String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            sitePath = this.configurationService.getLivePortalsLocation(repository).getPath();
        }
        return sitePath;
    }

    private void mapFulltextQueryTearm(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        String keyword = queryCriteria.getKeyword();
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        AbstractQueryBuilder.QueryTermHelper queryTermHelper = new AbstractQueryBuilder.QueryTermHelper();
        String queryTerm = null;
        keyword = keyword.replaceAll("'", "''");
        if (this.isEnabledFuzzySearch) {
            queryTerm = keyword.contains("*") || keyword.contains("?") || keyword.contains("~") ? queryTermHelper.contains(keyword).buildTerm() : queryTermHelper.contains(keyword).allowFuzzySearch(this.fuzzySearchIndex).buildTerm();
        } else {
            keyword = keyword.replace("~", "\\~");
            keyword = keyword.replace("*", "\\*");
            keyword = keyword.replace("?", "\\?");
            queryTerm = queryTermHelper.contains(keyword).buildTerm();
        }
        String scope = queryCriteria.getFulltextSearchProperty();
        if (".".equals(scope) || scope == null) {
            queryBuilder.contains(null, queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.contains(scope, queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
        }
    }

    private void searchByNodeName(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.queryByNodeName(this.getSitePath(queryCriteria), queryCriteria.getKeyword());
    }

    private void mapDatetimeRangeSelected(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        QueryCriteria.DATE_RANGE_SELECTED selectedDateRange = queryCriteria.getDateRangeSelected();
        if (selectedDateRange == null) {
            return;
        }
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED == selectedDateRange) {
            QueryCriteria.DatetimeRange createdDateRange = queryCriteria.getCreatedDateRange();
            queryBuilder.betweenDates("exo:dateCreated", createdDateRange.getFromDate(), createdDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED == selectedDateRange) {
            QueryCriteria.DatetimeRange modifiedDateRange = queryCriteria.getLastModifiedDateRange();
            queryBuilder.betweenDates("exo:dateModified", modifiedDateRange.getFromDate(), modifiedDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else {
            if (QueryCriteria.DATE_RANGE_SELECTED.START_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
            if (QueryCriteria.DATE_RANGE_SELECTED.END_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void mapCategoriesCondition(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        String[] categoryUUIDs = queryCriteria.getCategoryUUIDs();
        if (categoryUUIDs == null) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.like("exo:category", categoryUUIDs[0], AbstractQueryBuilder.LOGICAL.NULL);
        if (categoryUUIDs.length > 1) {
            for (int i = 1; i < categoryUUIDs.length; ++i) {
                queryBuilder.like("exo:category", categoryUUIDs[i], AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapMetadataProperties(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        QueryCriteria.QueryProperty[] queryProperty = queryCriteria.getQueryMetadatas();
        if (queryProperty == null) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.like(queryProperty[0].getName(), queryProperty[0].getName(), AbstractQueryBuilder.LOGICAL.NULL);
        if (queryProperty.length > 1) {
            for (int i = 1; i < queryProperty.length; ++i) {
                queryBuilder.like(queryProperty[i].getName(), queryProperty[i].getName(), AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapQuerySpecificNodeTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder, NodeTypeManager nodeTypeManager) throws Exception {
        String[] contentTypes = queryCriteria.getContentTypes();
        NodeType fistType = nodeTypeManager.getNodeType(contentTypes[0]);
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        if (fistType.isMixin()) {
            queryBuilder.like("jcr:mixinTypes", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.equal("jcr:primaryType", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        }
        if (contentTypes.length > 1) {
            for (int i = 1; i < contentTypes.length; ++i) {
                String type = contentTypes[i];
                NodeType nodetype = nodeTypeManager.getNodeType(type);
                if (nodetype.isMixin()) {
                    queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                    continue;
                }
                queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void mapQueryTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.selectTypes(null);
        queryBuilder.fromNodeTypes(null);
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        ExtendedNodeTypeManager manager = currentRepository.getNodeTypeManager();
        String[] contentTypes = queryCriteria.getContentTypes();
        if (contentTypes != null && contentTypes.length > 0 && queryCriteria.getKeyword() == null) {
            this.mapQuerySpecificNodeTypes(queryCriteria, queryBuilder, (NodeTypeManager)manager);
            return;
        }
        List selectedNodeTypes = this.templateService.getDocumentTemplates(currentRepository.getConfiguration().getName());
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.equal("jcr:primaryType", "nt:resource", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.equal("jcr:mixinTypes", "exo:rss-enable", AbstractQueryBuilder.LOGICAL.OR);
        ArrayList<String> publicatioTypes = new ArrayList<String>(4);
        NodeTypeIterator iterator = manager.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType nodeType = iterator.nextNodeType();
            if (nodeType.isNodeType("publication:webpagesPublication")) {
                publicatioTypes.add(nodeType.getName());
                continue;
            }
            if (!nodeType.isNodeType("exo:metadata")) continue;
            if (nodeType.isMixin()) {
                queryBuilder.equal("jcr:mixinTypes", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
        }
        for (String type : selectedNodeTypes) {
            NodeType nodetype = manager.getNodeType(type);
            if (nodetype.isMixin()) {
                queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        if (this.excludeMimeTypes.size() < 1) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        String[] mimetypes = this.excludeMimeTypes.toArray(new String[0]);
        queryBuilder.equal("jcr:mimeType", mimetypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        for (int i = 1; i < mimetypes.length; ++i) {
            queryBuilder.equal("jcr:mimeType", mimetypes[i], AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void orderBy(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        queryBuilder.orderBy("jcr:score", AbstractQueryBuilder.ORDERBY.DESC);
    }
}

