/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.template;

import com.arjuna.ats.internal.arjuna.template.OrderedListElement;
import com.arjuna.ats.internal.arjuna.template.OrderedListEntry;
import com.arjuna.ats.internal.arjuna.template.OrderedListIterator;

public class OrderedList {
    private OrderedListEntry _headOfList = null;
    private long _entryCount = 0L;
    private boolean _increasing;

    public OrderedList() {
        this(true);
    }

    public OrderedList(boolean increasing) {
        this._increasing = increasing;
    }

    public void finalize() {
        this.empty();
    }

    public final synchronized boolean insert(OrderedListElement p) {
        return this.insert(p, false);
    }

    public final synchronized boolean insert(OrderedListElement p, boolean prior) {
        if (p == null) {
            return false;
        }
        if (this._entryCount == 0L) {
            this._headOfList = new OrderedListEntry(p, this._headOfList);
            ++this._entryCount;
            return true;
        }
        OrderedListIterator iter = new OrderedListIterator(this);
        OrderedListElement prev = null;
        OrderedListElement q = iter.iterate();
        while (q != null) {
            if (this._increasing ? (prior ? q.equals(p) || q.greaterThan(p) : q.greaterThan(p)) : (prior ? q.equals(p) || q.lessThan(p) : q.lessThan(p))) {
                return this.insertBefore(p, q);
            }
            prev = q;
            q = iter.iterate();
        }
        return this.insertAfter(p, prev);
    }

    public final synchronized boolean insertBefore(OrderedListElement toInsert, OrderedListElement before) {
        OrderedListEntry prev = null;
        for (OrderedListEntry p = this._headOfList; p != null; p = p.cdr()) {
            if (p.car() == before) {
                OrderedListEntry newcons = new OrderedListEntry(toInsert, p);
                if (prev != null) {
                    prev.setfCdr(newcons);
                } else {
                    this._headOfList = newcons;
                }
                ++this._entryCount;
                return true;
            }
            prev = p;
        }
        return false;
    }

    public final synchronized boolean insertAfter(OrderedListElement toInsert, OrderedListElement after) {
        for (OrderedListEntry p = this._headOfList; p != null; p = p.cdr()) {
            if (p.car() != after) continue;
            OrderedListEntry newcons = new OrderedListEntry(toInsert, p.cdr());
            p.setfCdr(newcons);
            ++this._entryCount;
            return true;
        }
        return false;
    }

    public final synchronized boolean remove(OrderedListElement element) {
        if (this._headOfList == null || element == null) {
            return false;
        }
        OrderedListEntry prev = null;
        for (OrderedListEntry ptr = this._headOfList; ptr != null; ptr = ptr.cdr()) {
            if (ptr.car() == element) {
                if (prev != null) {
                    prev.setfCdr(ptr.cdr());
                } else {
                    this._headOfList = ptr.cdr();
                }
                ptr.setfCdr(null);
                --this._entryCount;
                return true;
            }
            prev = ptr;
        }
        return false;
    }

    public final synchronized OrderedListElement orderedPop() {
        if (this._headOfList != null) {
            OrderedListEntry remove = this._headOfList;
            OrderedListElement p = this._headOfList.car();
            this._headOfList = remove.cdr();
            remove.setfCdr(null);
            --this._entryCount;
            remove = null;
            return p;
        }
        return null;
    }

    public final synchronized OrderedListElement peak() {
        if (this._headOfList != null) {
            return this._headOfList.car();
        }
        return null;
    }

    final synchronized OrderedListEntry head() {
        return this._headOfList;
    }

    public final synchronized void empty() {
        OrderedListElement te;
        while ((te = this.orderedPop()) != null) {
            te = null;
        }
    }

    public final synchronized long size() {
        return this._entryCount;
    }
}

