/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.cyberneko.html.filters.ElementRemover;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.social.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class LinkShare
extends DefaultFilter {
    private final String MEDIUM_TYPE_NEWS = "news";
    private final String MEDIUM_TYPE_AUDIO = "audio";
    private final String MEDIUM_TYPE_IMAGE = "image";
    private final String MEDIUM_TYPE_VIDEO = "video";
    private final String MEDIUM_TYPE_BLOG = "blog";
    private final String MEDIUM_TYPE_MULT = "mult";
    private String mediumType = "news";
    private String mediaSrc;
    private String mediaType;
    private String mediaTitle;
    private String mediaArtist;
    private String mediaAlbum;
    private String mediaHeight;
    private String mediaWidth;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final int MIN_WIDTH = 55;
    private static final int MIN_HEIGHT = 55;
    private static final int MAX_DESCRIPTION = 500;
    private static String lang = "en";
    private String link;
    private String title;
    private String description;
    private String imageSrc;
    private List<String> images;
    private HashMap<String, String> descriptions;
    private String temp;
    private StringBuffer pText;
    private boolean firstPTagParsed = false;
    private boolean onPParsing = false;
    private boolean headEnded = false;

    private LinkShare() {
    }

    public String getLink() {
        return this.link;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getImages() {
        return this.images;
    }

    public String getMediumType() {
        return this.mediumType;
    }

    public String getMediaSrc() {
        return this.mediaSrc;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMediaTitle() {
        return this.mediaTitle;
    }

    public String getMediaArtist() {
        return this.mediaArtist;
    }

    public String getMediaAlbum() {
        return this.mediaAlbum;
    }

    public String getMediaHeight() {
        return this.mediaHeight;
    }

    public String getMediaWidth() {
        return this.mediaWidth;
    }

    private void get() throws Exception {
        ElementRemover remover = new ElementRemover();
        remover.acceptElement("head", null);
        remover.acceptElement("meta", new String[]{"name", "content", "lang"});
        remover.acceptElement("link", new String[]{"rel", "href"});
        remover.acceptElement("title", null);
        remover.acceptElement("img", new String[]{"src", "width", "height"});
        remover.acceptElement("p", null);
        remover.acceptElement("a", null);
        remover.acceptElement("b", null);
        remover.acceptElement("i", null);
        remover.acceptElement("strong", null);
        remover.removeElement("script");
        XMLDocumentFilter[] filter = new XMLDocumentFilter[]{remover};
        HTMLConfiguration parser = new HTMLConfiguration();
        parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filter);
        parser.setDocumentHandler((XMLDocumentHandler)this);
        XMLInputSource source = new XMLInputSource(null, this.link, null);
        try {
            parser.parse(source);
        }
        catch (NullPointerException ne) {
            ExoLogger.getLogger(LinkShare.class).warn((Object)"Problem when parsing the link in LinkShare.getInstance(String) method");
        }
        catch (IOException e) {
            this.title = this.link;
        }
        catch (Exception e) {
            this.title = this.link;
        }
    }

    public static LinkShare getInstance(String link) throws Exception {
        return LinkShare.getInstance(link, lang);
    }

    public static LinkShare getInstance(String link, String lang) throws Exception {
        HashMap<String, String> descriptions;
        if (link == null) {
            return null;
        }
        if (!Util.isValidURL((String)link)) {
            return null;
        }
        LinkShare linkShare = new LinkShare();
        if (!link.startsWith(HTTP_PROTOCOL) && !link.startsWith(HTTPS_PROTOCOL)) {
            URI uri = URI.create(link);
            String uriScheme = uri.getScheme();
            link = uriScheme != null ? HTTP_PROTOCOL + uri.getSchemeSpecificPart() : HTTP_PROTOCOL + link;
        }
        linkShare.link = link;
        LinkShare.lang = lang;
        linkShare.get();
        if (linkShare.title == null || linkShare.title.trim().length() == 0) {
            linkShare.title = link;
        }
        if (linkShare.imageSrc != null) {
            ArrayList<String> images = new ArrayList<String>();
            images.add(linkShare.imageSrc);
            linkShare.images = images;
        }
        if ((descriptions = linkShare.descriptions) != null) {
            String description = descriptions.get(LinkShare.lang);
            if (description == null) {
                Collection<String> values = descriptions.values();
                description = values.iterator().next();
            }
            linkShare.description = description;
            String tail = "";
            if (description.length() > 500) {
                tail = "...";
                linkShare.description = description.substring(0, 499) + tail;
            }
        }
        if (linkShare.description == null) {
            linkShare.description = "";
        }
        if (linkShare.images == null) {
            linkShare.images = new ArrayList<String>();
        }
        return linkShare;
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) {
        if (this.headEnded && this.descriptions == null && !this.firstPTagParsed && "p".equalsIgnoreCase(element.rawname)) {
            this.firstPTagParsed = true;
            this.onPParsing = true;
        }
    }

    public void endElement(QName element, Augmentations augs) {
        if ("title".equalsIgnoreCase(element.rawname) && this.title == null) {
            this.title = this.temp;
            this.title = this.title.replaceAll("\n", "");
        }
        if ("head".equalsIgnoreCase(element.rawname)) {
            this.headEnded = true;
        }
        if (this.onPParsing && "p".equalsIgnoreCase(element.rawname)) {
            this.onPParsing = false;
            this.description = this.pText.toString();
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) {
        if ("link".equalsIgnoreCase(element.rawname)) {
            String relValue = attributes.getValue("rel");
            String hrefValue = attributes.getValue("href");
            if (hrefValue != null) {
                hrefValue = this.getAbsLink(hrefValue);
            }
            if ("image_src".equalsIgnoreCase(relValue)) {
                this.imageSrc = hrefValue;
            } else if ("audio_src".equalsIgnoreCase(relValue)) {
                this.mediaSrc = hrefValue;
                this.mediumType = "audio";
            } else if ("video_src".equalsIgnoreCase(relValue)) {
                this.mediaSrc = hrefValue;
                this.mediumType = "video";
            }
        } else if ("meta".equalsIgnoreCase(element.rawname)) {
            String nameValue = attributes.getValue("name");
            if (nameValue == null) {
                return;
            }
            String contentValue = attributes.getValue("content");
            if (contentValue == null) {
                return;
            }
            if ("medium".equalsIgnoreCase(nameValue)) {
                if ("news".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "news";
                } else if ("audio".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "audio";
                } else if ("image".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "image";
                } else if ("video".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "video";
                } else if ("blog".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "blog";
                } else if ("mult".equalsIgnoreCase(contentValue)) {
                    this.mediumType = "mult";
                }
            } else if ("title".equalsIgnoreCase(nameValue)) {
                this.title = contentValue;
            } else if ("description".equalsIgnoreCase(nameValue)) {
                String langValue = attributes.getValue("lang");
                if (langValue != null) {
                    if (this.descriptions == null) {
                        this.descriptions = new HashMap();
                    }
                    this.descriptions.put(langValue, contentValue);
                } else {
                    this.description = contentValue;
                }
            }
            if (this.mediumType.equals("audio") || this.mediumType.equals("mult")) {
                if ("audio_type".equalsIgnoreCase(nameValue)) {
                    this.mediaType = contentValue;
                } else if ("audio_title".equalsIgnoreCase(nameValue)) {
                    this.mediaTitle = contentValue;
                } else if ("audio_artist".equalsIgnoreCase(nameValue)) {
                    this.mediaArtist = contentValue;
                } else if ("audio_album".equalsIgnoreCase(nameValue)) {
                    this.mediaAlbum = contentValue;
                }
            } else if (this.mediumType.equals("video") || this.mediumType.equals("mult")) {
                if ("video_type".equalsIgnoreCase(nameValue)) {
                    this.mediaType = contentValue;
                } else if ("video_title".equalsIgnoreCase(nameValue)) {
                    this.mediaTitle = contentValue;
                } else if ("video_height".equalsIgnoreCase(nameValue)) {
                    this.mediaHeight = contentValue;
                } else if ("video_width".equalsIgnoreCase(nameValue)) {
                    this.mediaWidth = contentValue;
                } else if ("video_artist".equalsIgnoreCase(nameValue)) {
                    this.mediaArtist = contentValue;
                } else if ("video_album".equalsIgnoreCase(nameValue)) {
                    this.mediaAlbum = contentValue;
                }
            }
        } else if (this.imageSrc == null && "img".equalsIgnoreCase(element.rawname)) {
            String width = attributes.getValue("width");
            String height = attributes.getValue("height");
            if (width != null && height != null) {
                int w = this.getNumber(width);
                int h = this.getNumber(height);
                if (w > 55 || h > 55) {
                    String src = attributes.getValue("src");
                    if (src == null) {
                        return;
                    }
                    src = this.getAbsLink(src);
                    if (this.images == null) {
                        this.images = new ArrayList<String>();
                    }
                    this.images.add(src);
                }
            }
        }
    }

    public void characters(XMLString text, Augmentations augs) {
        this.temp = text.toString();
        if (this.onPParsing) {
            if (this.pText == null) {
                this.pText = new StringBuffer();
            }
            this.pText.append(this.temp);
        }
    }

    private String getAbsLink(String link) {
        if (link.startsWith(HTTP_PROTOCOL)) {
            return link;
        }
        URL url = null;
        try {
            url = new URL(this.link);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        String protocol = url.getProtocol();
        String host = url.getHost();
        String base = protocol + "://" + host;
        if (link.startsWith("/")) {
            return base + link;
        }
        if (link.startsWith("./")) {
            if (this.link.endsWith("/")) {
                this.link = this.link.substring(0, this.link.length() - 1);
            }
            link = link.substring(1, link.length());
            return this.link + link;
        }
        if (link.startsWith("../")) {
            String regex = "\\.\\./";
            Pattern partern = Pattern.compile(regex);
            Matcher matcher = partern.matcher(link);
            int level = 0;
            while (matcher.find()) {
                ++level;
            }
            String secondPath = link.replace("(\\.\\./)+", "");
            String[] str = this.link.split("/");
            StringBuffer sb = new StringBuffer();
            level = str.length - 1 - level;
            for (int i = 0; i < level; ++i) {
                sb.append(str[i]);
            }
            sb.append(secondPath);
            return sb.toString();
        }
        if (this.link.endsWith("/")) {
            return this.link + link;
        }
        return this.link + "/" + link;
    }

    private int getNumber(String str) {
        str = str.trim();
        String regex = "\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        String strNum = null;
        Integer intVal = 0;
        while (matcher.find()) {
            strNum = matcher.group();
        }
        if (strNum != null) {
            intVal = Integer.parseInt(strNum);
        }
        return intVal;
    }
}

