/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.lfu;

import java.io.Serializable;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.ExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.lfu.LFUExoCacheConfig;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LFUAlgorithmConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUExoCacheCreator
implements ExoCacheCreator {
    public static final String EXPECTED_IMPL = "LFU";
    protected int defaultMinNodes;

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache) throws ExoCacheInitException {
        if (config instanceof LFUExoCacheConfig) {
            LFUExoCacheConfig lfuConfig = (LFUExoCacheConfig)config;
            return this.create(config, cache, lfuConfig.getMaxNodes(), lfuConfig.getMinNodes(), lfuConfig.getMinTimeToLive());
        }
        long period = config.getLiveTime();
        return this.create(config, cache, config.getMaxSize(), this.defaultMinNodes, period > 0L ? period * 1000L : 0L);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache, int maxNodes, int minNodes, long minTimeToLive) throws ExoCacheInitException {
        Configuration configuration = cache.getConfiguration();
        LFUAlgorithmConfig lfu = new LFUAlgorithmConfig(maxNodes, minNodes);
        lfu.setMinTimeToLive(minTimeToLive);
        EvictionRegionConfig erc = new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)lfu);
        EvictionConfig evictionConfig = configuration.getEvictionConfig();
        evictionConfig.setDefaultEvictionRegionConfig(erc);
        return new LFUExoCache(config, cache, lfu);
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return LFUExoCacheConfig.class;
    }

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LFUExoCache
    extends AbstractExoCache<Serializable, Object> {
        private final LFUAlgorithmConfig lfu;

        public LFUExoCache(ExoCacheConfig config, Cache<Serializable, Object> cache, LFUAlgorithmConfig lfu) {
            super(config, cache);
            this.lfu = lfu;
        }

        @ManagedName(value="MinTimeToLive")
        @ManagedDescription(value="the minimum amount of time a node must be allowed to live after being accessed before it is allowed to be considered for eviction. 0 denotes that this feature is disabled, which is the default value.")
        public long getLiveTime() {
            return this.lfu.getMinTimeToLive();
        }

        @ManagedName(value="MaxNodes")
        @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes immediate expiry, -1 denotes no limit.")
        public int getMaxSize() {
            return this.lfu.getMaxNodes();
        }

        @Managed
        @ManagedName(value="MinNodes")
        @ManagedDescription(value="This is the minimum number of nodes allowed in this region. This value determines what the eviction queue should prune down to per pass. e.g. If minNodes is 10 and the cache grows to 100 nodes, the cache is pruned down to the 10 most frequently used nodes when the eviction timer makes a pass through the eviction algorithm.")
        public long getMinNodes() {
            return this.lfu.getMinNodes();
        }

        public void setLiveTime(long period) {
            this.lfu.setMinTimeToLive(period);
        }

        public void setMaxSize(int max) {
            this.lfu.setMaxNodes(max);
        }

        @Managed
        public void setMinNodes(int minNodes) {
            this.lfu.setMinNodes(minNodes);
        }
    }
}

