/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion.xstream;

import com.google.inject.Injector;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Collection;
import org.apache.shindig.protocol.conversion.xstream.GuiceBeanProvider;
import org.apache.shindig.protocol.model.Exportablebean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceBeanConverter
implements Converter {
    private Mapper mapper;
    private GuiceBeanProvider beanProvider;

    public GuiceBeanConverter(Mapper mapper, Injector injector) {
        this(mapper, new GuiceBeanProvider(injector));
    }

    public GuiceBeanConverter(Mapper mapper, GuiceBeanProvider beanProvider) {
        this.mapper = mapper;
        this.beanProvider = beanProvider;
    }

    public boolean canConvert(Class type) {
        while (type != null) {
            if (Object.class.equals((Object)type)) {
                return false;
            }
            if (type.isInterface()) {
                return true;
            }
            for (Class<?> iff : type.getInterfaces()) {
                if (!iff.isAnnotationPresent(Exportablebean.class)) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        this.beanProvider.visitSerializableProperties(source, new GuiceBeanProvider.Visitor(){

            @Override
            public boolean shouldVisit(String name, Class<?> definedIn) {
                return GuiceBeanConverter.this.mapper.shouldSerializeMember(definedIn, name);
            }

            @Override
            public void visit(String propertyName, Class<?> fieldType, Class<?> definedIn, Object newObj) {
                if (newObj != null) {
                    Mapper.ImplicitCollectionMapping mapping = GuiceBeanConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), propertyName);
                    if (mapping != null) {
                        if (mapping.getItemFieldName() != null) {
                            Collection list = (Collection)newObj;
                            for (Object obj : list) {
                                this.writeField(propertyName, mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(propertyName, propertyName, fieldType, definedIn, newObj);
                    }
                }
            }

            private void writeField(String propertyName, String aliasName, Class<?> fieldType, Class<?> definedIn, Object newObj) {
                ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)GuiceBeanConverter.this.mapper.serializedMember(source.getClass(), aliasName), fieldType);
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.mapper.realMember(result.getClass(), reader.getNodeName());
            boolean propertyExistsInClass = this.beanProvider.propertyDefinedInClass(propertyName, result.getClass());
            if (propertyExistsInClass) {
                Class<?> type = this.determineType(reader, result, propertyName);
                Object value = context.convertAnother(result, type);
                this.beanProvider.writeProperty(result, propertyName, value);
            } else if (this.mapper.shouldSerializeMember(result.getClass(), propertyName)) {
                throw new ConversionException("Property '" + propertyName + "' not defined in class " + result.getClass().getName());
            }
            reader.moveUp();
        }
        return result;
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class<?> determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttributeName = this.mapper.attributeForAlias("class");
        String classAttribute = reader.getAttribute(classAttributeName);
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        return this.mapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }

    @Deprecated
    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }
}

