/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URI {
    private String uri_;
    private String scheme_;
    private String host_;
    int port_ = 80;
    private String pathInfo_;
    private Map<String, Parameter> params_;

    public URI(String scheme, String host, int port, String pathInfo, Map<String, Parameter> params) {
        this.scheme_ = scheme;
        this.host_ = host;
        this.port_ = port;
        this.pathInfo_ = pathInfo;
        this.params_ = params;
        StringBuilder b = new StringBuilder();
        b.append(this.scheme_).append(this.host_).append(":").append(this.port_).append(this.pathInfo_);
        if (this.params_ != null && this.params_.size() > 0) {
            b.append("?");
            int counter = 0;
            for (Parameter param : this.params_.values()) {
                b.append(param.name).append('=').append(param.value);
                if (counter != this.params_.size() - 1) {
                    b.append("&");
                }
                ++counter;
            }
        }
        this.uri_ = b.toString();
    }

    public URI(String uri) throws Exception {
        int questionMarkIndex;
        this.uri_ = uri;
        int schemeLimitIndex = uri.indexOf("//") + 1;
        if (schemeLimitIndex > 0) {
            this.scheme_ = uri.substring(0, schemeLimitIndex + 1);
        } else {
            schemeLimitIndex = -1;
            this.scheme_ = "";
        }
        int hostPortLimitIndex = uri.indexOf("/", schemeLimitIndex + 1);
        if (hostPortLimitIndex < 0) {
            hostPortLimitIndex = uri.length();
        }
        String hostPort = uri.substring(schemeLimitIndex + 1, hostPortLimitIndex);
        int hostLimitIndex = hostPort.indexOf(58);
        this.host_ = hostPort;
        if (hostLimitIndex > 0) {
            this.host_ = hostPort.substring(0, hostLimitIndex);
            this.port_ = Integer.parseInt(hostPort.substring(hostLimitIndex + 1, hostPort.length()));
        }
        this.pathInfo_ = (questionMarkIndex = uri.indexOf("?", hostPortLimitIndex)) > 0 ? uri.substring(hostPortLimitIndex, questionMarkIndex) : uri.substring(hostPortLimitIndex, uri.length());
        if (questionMarkIndex > 0) {
            String[] params;
            this.params_ = new LinkedHashMap<String, Parameter>();
            String paramsString = uri.substring(questionMarkIndex + 1, uri.length());
            paramsString = paramsString.replace("&amp;", "&");
            for (String param : params = paramsString.split("&")) {
                String[] pair = param.split("=", 2);
                if (pair.length == 2) {
                    this.params_.put(pair[0], new Parameter(pair[0], pair[1]));
                    continue;
                }
                this.params_.put(pair[0], new Parameter(pair[0], ""));
            }
        }
    }

    public String getURI() {
        return this.uri_;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public String getHost() {
        return this.host_;
    }

    public int getPort() {
        return this.port_;
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public Map<String, Parameter> getParameters() {
        return this.params_;
    }

    public Map<String, Parameter> getCloneParameters() {
        if (this.params_ == null) {
            return null;
        }
        return new LinkedHashMap<String, Parameter>(this.params_);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("scheme = ").append(this.scheme_).append(", ");
        b.append("host = ").append(this.host_).append(", ");
        b.append("port = ").append(this.port_).append(", ");
        b.append("path info = ").append(this.pathInfo_).append(", ");
        if (this.params_ != null) {
            b.append("params =[ ");
            for (Parameter entry : this.params_.values()) {
                b.append(entry.name).append("=").append(entry.value).append("|");
            }
        }
        return b.toString();
    }
}

