/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.SystemViewStreamExporter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WorkspaceSystemViewStreamExporter
extends SystemViewStreamExporter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.WorkspaceSystemViewStreamExporter");

    public WorkspaceSystemViewStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        super.entering(node, level);
        try {
            this.writer.writeAttribute("exo", "http://www.exoplatform.com/jcr/exo/1.0", "id", node.getIdentifier());
        }
        catch (XMLStreamException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        try {
            this.writer.writeStartElement("sv", "property", this.getSvNamespaceUri());
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "name", this.getExportName(property, false));
            this.writer.writeAttribute("sv", this.getSvNamespaceUri(), "type", ExtendedPropertyType.nameFromValue(property.getType()));
            this.writer.writeAttribute("exo", "http://www.exoplatform.com/jcr/exo/1.0", "id", property.getIdentifier());
            if (property.isMultiValued()) {
                this.writer.writeAttribute("exo", "http://www.exoplatform.com/jcr/exo/1.0", "multivalued", "true");
            }
            List<ValueData> values = property.getValues();
            for (ValueData valueData : values) {
                this.writer.writeStartElement("sv", "value", this.getSvNamespaceUri());
                this.writeValueData(valueData, property.getType());
                this.writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
    }
}

