/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.ks.common.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/AnswerUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={CommentQuestionActionListener.class})})
public class AnswerUIActivity
extends BaseUIActivity {
    protected Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private List<Activity> questionComments_;

    public String getUriOfAuthor() {
        String userId = this.getActivity().getUserId();
        try {
            return "<a href='" + this.getUserProfileUri(userId) + "'>" + this.getUserFullName(userId) + "</a>";
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("can not get Url of user " + userId), (Throwable)e);
            }
            return "";
        }
    }

    private Activity toActivity(Comment comment) {
        Activity activity = null;
        if (comment != null) {
            activity = new Activity();
            IdentityManager identityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", comment.getCommentBy());
            activity.setUserId(userIdentity.getId());
            activity.setTitle(comment.getComments());
            activity.setPostedTime(Long.valueOf(comment.getDateComment().getTime()));
            activity.setId(comment.getId());
        }
        return activity;
    }

    public List<Activity> getComments() {
        if (this.isQuestionActivity()) {
            block6: {
                if (this.questionComments_ == null) {
                    this.questionComments_ = new ArrayList<Activity>();
                }
                if (this.questionComments_.isEmpty()) {
                    FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
                    try {
                        Comment[] comments;
                        for (Comment comment : comments = faqService.getComments(this.getActivityParamValue("QuestionId"))) {
                            Activity act = this.toActivity(comment);
                            if (act == null) continue;
                            this.questionComments_.add(act);
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isWarnEnabled()) break block6;
                        this.log.warn((Object)("can not get comments of question: " + this.getActivityParamValue("QuestionId")), (Throwable)e);
                    }
                }
            }
            return this.questionComments_;
        }
        return super.getComments();
    }

    private String getTitle(WebuiBindingContext _ctx) throws Exception {
        String title = "";
        if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-update");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-update");
        }
        title = title.replace("{0}", this.getUriOfAuthor()).replace("{1}", "<a href=" + this.getActivityParamValue("Link") + ">" + this.getActivityParamValue("Name") + "</a>");
        return title;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    public boolean isQuestionActivity() {
        String value = this.getActivityParamValue("ActivityType");
        return value.indexOf("Question") >= 0;
    }

    public static String getFullName(String userName) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userName);
            String fullName = user.getFullName();
            if (fullName == null || fullName.trim().length() <= 0) {
                fullName = userName;
            }
            return fullName;
        }
        catch (Exception e) {
            return userName;
        }
    }

    public static String getLinkDiscuss(String topicId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String link = portalContext.getRequest().getRequestURL().toString();
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = "/" + Util.getUIPortal().getName();
        if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
            link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        link = link.substring(0, link.indexOf(selectedNode) + selectedNode.length());
        link = link.replaceAll(selectedNode, "forum") + "/" + org.exoplatform.forum.service.Utils.TOPIC + "/" + topicId;
        return link;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommentQuestionActionListener
    extends EventListener<AnswerUIActivity> {
        public void execute(Event<AnswerUIActivity> event) throws Exception {
            ForumService forumService;
            Topic topic;
            AnswerUIActivity uiActivity = (AnswerUIActivity)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            UIApplication application = (UIApplication)uiActivity.getAncestorOfType(UIApplication.class);
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            if (message == null || message.trim().length() == 0) {
                application.addMessage(new ApplicationMessage("AnswerUIActivity.msg.content-empty", null, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                return;
            }
            FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            Question question = faqService.getQuestionById(uiActivity.getActivityParamValue("QuestionId"));
            Comment comment = new Comment();
            comment.setNew(true);
            comment.setCommentBy(context.getRemoteUser());
            comment.setComments(message);
            comment.setFullName(AnswerUIActivity.getFullName(context.getRemoteUser()));
            comment.setDateComment(new Date());
            String topicId = question.getTopicIdDiscuss();
            if (topicId != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class)).getObjectNameById(topicId, org.exoplatform.forum.service.Utils.TOPIC)) != null) {
                String remoteAddr = Utils.getRemoteIP();
                String[] ids = topic.getPath().split("/");
                int t = ids.length;
                String linkForum = AnswerUIActivity.getLinkDiscuss(topicId);
                String postId = comment.getPostId();
                if (postId == null || postId.length() == 0) {
                    Post post = new Post();
                    post.setOwner(context.getRemoteUser());
                    post.setIcon("ViewIcon");
                    post.setName("Re: " + question.getQuestion());
                    post.setMessage(comment.getComments());
                    post.setLink(linkForum);
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setRemoteAddr(remoteAddr);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, "");
                    comment.setPostId(post.getId());
                } else {
                    Post post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                    boolean isNew = false;
                    if (post == null) {
                        post = new Post();
                        isNew = true;
                        post.setOwner(context.getRemoteUser());
                        post.setIcon("ViewIcon");
                        post.setName("Re: " + question.getQuestion());
                        comment.setPostId(post.getId());
                        post.setLink(linkForum);
                        post.setRemoteAddr(remoteAddr);
                    } else {
                        post.setModifiedBy(context.getRemoteUser());
                    }
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setMessage(comment.getComments());
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, isNew, "");
                }
            }
            faqService.saveComment(question.getPath(), comment, uiActivity.getActivityParamValue("Language"));
            Activity act = uiActivity.toActivity(comment);
            if (act != null) {
                uiActivity.questionComments_.add(act);
            }
            uiFormComment.reset();
            uiActivity.setCommentFormFocused(true);
            context.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

