/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceActivityListAccess
implements ListAccess<Activity> {
    private static final Log LOG = ExoLogger.getLogger(SpaceActivityListAccess.class);
    private Space space;
    private Identity spaceIdentity = null;
    private ActivityManager activityManager;

    public SpaceActivityListAccess(Space space) {
        this.space = space;
        IdentityManager identityManager = (IdentityManager)PortalContainer.getComponent(IdentityManager.class);
        this.activityManager = (ActivityManager)PortalContainer.getComponent(ActivityManager.class);
        try {
            this.spaceIdentity = identityManager.getOrCreateIdentity("space", space.getId());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public int getSize() throws Exception {
        return this.activityManager.getActivitiesCount(this.spaceIdentity);
    }

    public Activity[] load(int index, int length) throws Exception {
        Object[] objects = this.activityManager.getActivities(this.spaceIdentity, (long)index, (long)length).toArray();
        Activity[] results = new Activity[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = (Activity)objects[i];
        }
        return results;
    }
}

